package com.edgeti.services
{
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.http.HTTPService;
	
	public class DataService
	{
		private var service:HTTPService;
		
		public function DataService(endPoint:String) {
			service = new HTTPService();
			service.url = endPoint;
			service.useProxy = false;
			service.resultFormat = "e4x";
			var header:Object = new Object();
			header["HTTP-EQUIV"] = "Pragma";
			header["CONTENT"] = "no-cache";
			service.headers = header;
		}

		public function getSourceData():void {
			service.send();
		}
		
		public function disconnect():void {
			service.disconnect();
		}
		
		public function addFaultListener(listener:Function):void {
			service.addEventListener(FaultEvent.FAULT, listener);
		}
	
		public function addResultListener(listener:Function):void {
			service.addEventListener(ResultEvent.RESULT, listener);
		}
		
		public function removeResultListener(listener:Function):void {
			service.removeEventListener(ResultEvent.RESULT, listener);
		}
	}
}