package com.edgeti.XmlSerializer
{
	import com.edgeti.EdgeUtils.logger.Logger;
	
	import flash.display.DisplayObject;
	import flash.utils.Dictionary;
	
	import mx.binding.utils.ChangeWatcher;
	import mx.core.Container;
	import mx.events.PropertyChangeEvent;
			
	public class WrapperManager
	{
		protected var _logger:Logger = Logger.getLogger();
		[Bindable]
		public var xmlCodeString:String;
		
		private var _wrapperDict:Dictionary;
		
		/**
		 * Ctor. Creates the dictionary of wrapped objects and sets up a ChangeWatcher that 
		 * monitors the [Bindable] public var xmlCodeString
		 **/
		public function WrapperManager()
		{
			ChangeWatcher.watch(this, "xmlCodeString", handerFunction);
			_wrapperDict = new Dictionary();
		}
		
		/**
		 * Find a wrapped object by name
		 **/
		public function getWrapper(name:String):ObjectWrapper{
			return _wrapperDict[name];
			return null;
		}
		
		/**
		 * Find a wrapped object by the DisplayObject it wraps
		 **/
		public function getWrapperByDisplayObject(dobj:DisplayObject):ObjectWrapper{
			var wrapper:ObjectWrapper;
			
			for each(wrapper in _wrapperDict){
				if(wrapper != null){
					if(wrapper.getDisplayObject() == dobj){
						return wrapper;
					}
				}
			}
			return null;
		}
		
		/**
		* Removes a wrapper, and the wrappers of any DisplayObjects that are children of the 
		* wrapped object
		**/
		public function removeWrapper(name:String):void{
			var dobj:DisplayObject;
			var childDobj:DisplayObject;
			var child:ObjectWrapper;
			var container:Container;
			
			_logger.info("removing "+name);
			
			// find the wrapper
			var wrapper:ObjectWrapper = _wrapperDict[name];
			if(wrapper != null){
				
				// get the wrapped object;
				container = wrapper.getContainer();
				if(container != null){
					for each(childDobj in container.getChildren()){
						child = getWrapperByDisplayObject(childDobj);
						if(child != null){
							removeWrapper(child.name);
						}
					}
				}
				if(_wrapperDict.hasOwnProperty(wrapper.name)){
					_wrapperDict[wrapper.name] = null;
				}
				wrapper.dispose();
				wrapper = null;
			}
		}
		
		/**
		 * Given a Display object (created by MXML or programatically), wrap it and return the wrapper
		 **/
		public function wrapDisplayObject(obj:DisplayObject, name:String):ObjectWrapper{
			var wrapper:ObjectWrapper = new ObjectWrapper();
			wrapper.wrapDisplayObject(obj, name, this);
			_wrapperDict[name] = wrapper;
			return wrapper;
		}
		
		/**
		 * Given defining XML that defines an object and a parent Container, create a DisplayObject, add it
		 * as a child to the parent, and return the wrapped object. This will handle recursive creation of
		 * wrapped DisplayObjects, where each ObjectWrapper is added to this manager as it is created.
		 * 
		 *  Example wrapper is shown below:
		 * 
		 * <wrappedObject name="_myDataGrid">
		 *   <objectDescription className="mx.controls.DataGrid" name="_myDataGrid">
		 *     <property type="int" name="alpha" value="1"/>
		 *     <property type="int" name="baselinePosition" value="15"/>
		 *     <property type="String" name="blendMode" value="normal"/>
		 *     <property type="String" name="cachePolicy" value="auto"/>
		 * <............. additional property lines removed..............>
		 *     <property type="Boolean" name="visible" value="true"/>
		 *     <property type="int" name="width" value="845"/>
		 *     <property type="int" name="x" value="96"/>
		 *   </objectDescription>
		 *   <code>
		 *     <array name="dataProvider">
		 *       <object name="row1">
		 *         <int name="kittens" value="1"/>
		 *         <int name="puppies" value="2"/>
		 *         <int name="ponies" value="3"/>
		 *       </object>
		 *       <object name="row2">
		 *         <int name="kittens" value="2"/>
		 *         <int name="puppies" value="3"/>
		 *         <int name="ponies" value="4"/>
		 *       </object>
		 *       <object name="row3">
		 *         <int name="kittens" value="3"/>
		 *         <int name="puppies" value="4"/>
		 *         <int name="ponies" value="5"/>
		 *       </object>
		 *     </array>
		 *   </code>
		 * </wrappedObject>
		 **/
		public function wrapXml(xml:XML, parent:Container):ObjectWrapper{
			var name:String = xml.@name;
			_logger.info("wrapping: "+name);

			var wrapper:ObjectWrapper = new ObjectWrapper();
			wrapper.wrapXml(xml, name, this, parent);
			_wrapperDict[name] = wrapper;		
			return wrapper;
		}
		
		/**
		 * Get all the wrapper names managed by this class
		 **/
		public function getWrapperNames():Array{
			var name:String;
			var list:Array = new Array();
			for(name in _wrapperDict){
				if(_wrapperDict[name] != null){
					list.push(name);
				}
			}
			return list;
		}

		/**
		 * Handles xml data description for (ObjectWrapper) wrapped (DisplayObject) objects.
		 * An example xml is shown below:
		 * <code>
		 *	<target objectName="_consoleText">
		 *		<string name = "text" value = "The slow brown fox jumped over the lazy dog's back!"/>
		 *		<method name = "setStyle">
		 *			<arg value = "backgroundColor"/>
		 *			<arg value = "#CCCCCC"/>
		 *		</method>
		 *		<method name = "setStyle">
		 *			<arg value = "fontSize"/>
		 *			<arg value = "30"/>
		 *		</method>
		 *	</target>
		 * </code>
		 **/
		public function parseCode(xmlCode:String):void{
			var xml:XML;
			var targXml:XML;
			var wrapper:ObjectWrapper;
			var children:XMLList;
			var child:XML;

			try{
				xml = new XML(xmlCode);
				for each(targXml in xml.target){
					wrapper = getWrapper(targXml.@objectName);
					if(wrapper != null){
						children = targXml.children();
						for each(child in children){
							//_codeXml.appendChild(child);
							wrapper.parseCode(child);
						}
					}
				}
			}catch(err:TypeError){
				_logger.error(err.message);
			}
		}
		
		/**
		 * Method that gets called when the [Bindable] public xmlCodeString:String is changed
		 **/
		private function handerFunction(event:PropertyChangeEvent = null):void{
			parseCode(xmlCodeString)
		}
	}
}