package com.edgeti.XmlSerializer
{
	import com.edgeti.EdgeUtils.logger.Logger;
	
	import flash.display.DisplayObject;
	import flash.utils.Dictionary;
	import flash.utils.describeType;
	import flash.utils.getDefinitionByName;
	
	import mx.containers.Accordion;
	import mx.containers.ApplicationControlBar;
	import mx.containers.Box;
	import mx.containers.BoxDirection;
	import mx.containers.Canvas;
	import mx.containers.ControlBar;
	import mx.containers.DividedBox;
	import mx.containers.Form;
	import mx.containers.FormHeading;
	import mx.containers.FormItem;
	import mx.containers.FormItemDirection;
	import mx.containers.Grid;
	import mx.containers.GridItem;
	import mx.containers.GridRow;
	import mx.containers.HBox;
	import mx.containers.Panel;
	import mx.containers.TabNavigator;
	import mx.containers.Tile;
	import mx.containers.TileDirection;
	import mx.containers.TitleWindow;
	import mx.containers.ViewStack;
	import mx.controls.AdvancedDataGrid;
	import mx.controls.AdvancedDataGridBaseEx;
	import mx.controls.Alert;
	import mx.controls.Button;
	import mx.controls.ButtonBar;
	import mx.controls.ButtonLabelPlacement;
	import mx.controls.CheckBox;
	import mx.controls.ColorPicker;
	import mx.controls.ComboBase;
	import mx.controls.ComboBox;
	import mx.controls.DataGrid;
	import mx.controls.DateChooser;
	import mx.controls.DateField;
	import mx.controls.FormItemLabel;
	import mx.controls.HRule;
	import mx.controls.HScrollBar;
	import mx.controls.HSlider;
	import mx.controls.HorizontalList;
	import mx.controls.Image;
	import mx.controls.Label;
	import mx.controls.LinkBar;
	import mx.controls.LinkButton;
	import mx.controls.List;
	import mx.controls.Menu;
	import mx.controls.MenuBar;
	import mx.controls.NavBar;
	import mx.controls.NumericStepper;
	import mx.controls.OLAPDataGrid;
	import mx.controls.PopUpButton;
	import mx.controls.ProgressBar;
	import mx.controls.RadioButton;
	import mx.controls.RadioButtonGroup;
	import mx.controls.RichTextEditor;
	import mx.controls.SWFLoader;
	import mx.controls.Spacer;
	import mx.controls.TabBar;
	import mx.controls.Text;
	import mx.controls.TextArea;
	import mx.controls.TextInput;
	import mx.controls.TileList;
	import mx.controls.ToggleButtonBar;
	import mx.controls.ToolTip;
	import mx.controls.Tree;
	import mx.controls.VRule;
	import mx.controls.VScrollBar;
	import mx.controls.VSlider;
	import mx.controls.VideoDisplay;
	import mx.core.Container;
	import mx.utils.ObjectUtil;
	
	public class ObjectWrapper
	{
		private var _name:String;
		private var _wrappedObj:DisplayObject;
		private var _methodXmlDict:Dictionary;
		protected var _codeXml:XML;
		protected var _wrapperManager:WrapperManager;
		protected var _logger:Logger = Logger.getLogger();
		
		/**
		 * Create the wrapper, either from an DisplayObject, or from XML
		 **/
		public function ObjectWrapper()
		{
			_methodXmlDict = new Dictionary();

		}
		
		public function get name():String{
			return _name;
		}
		
		public function dispose():void{
			if(_wrappedObj != null){
				if(_wrappedObj.parent != null){
					_wrappedObj.parent.removeChild(_wrappedObj);
				} else {
					_logger.error(_name+" dispose() - no parent!");
				}
			}

			_wrappedObj = null;
			_methodXmlDict = new Dictionary();
		}

		/**
		 * Given a Display object (created by MXML or programatically), wrap it and return the wrapper
		 **/		
		public function wrapDisplayObject(obj:DisplayObject, name:String, wm:WrapperManager):void{
			_wrapperManager = wm;
			_codeXml = <code/>;
			_name = name;
			_wrappedObj = obj;

			findMethods();
		}

		/**
		 * Given defining XML that defines an object and a parent Container, create a DisplayObject, add it
		 * as a child to the parent, and return the wrapped object. This will handle recursive creation of
		 * wrapped DisplayObjects, where each ObjectWrapper is added to this manager as it is created.
		 * 
		 *  Example wrapper is shown below:
		 * 
		 * <wrappedObject name="_myDataGrid">
		 *   <objectDescription className="mx.controls.DataGrid" name="_myDataGrid">
		 *     <property type="int" name="alpha" value="1"/>
		 *     <property type="int" name="baselinePosition" value="15"/>
		 *     <property type="String" name="blendMode" value="normal"/>
		 *     <property type="String" name="cachePolicy" value="auto"/>
		 * <............. additional property lines removed..............>
		 *     <property type="Boolean" name="visible" value="true"/>
		 *     <property type="int" name="width" value="845"/>
		 *     <property type="int" name="x" value="96"/>
		 *   </objectDescription>
		 *   <code>
		 *     <array name="dataProvider">
		 *       <object name="row1">
		 *         <int name="kittens" value="1"/>
		 *         <int name="puppies" value="2"/>
		 *         <int name="ponies" value="3"/>
		 *       </object>
		 *       <object name="row2">
		 *         <int name="kittens" value="2"/>
		 *         <int name="puppies" value="3"/>
		 *         <int name="ponies" value="4"/>
		 *       </object>
		 *       <object name="row3">
		 *         <int name="kittens" value="3"/>
		 *         <int name="puppies" value="4"/>
		 *         <int name="ponies" value="5"/>
		 *       </object>
		 *     </array>
		 *   </code>
		 * </wrappedObject>
		 **/		
		public function wrapXml(xml:XML, name:String, wm:WrapperManager, parent:Container):void{
			var objXml:XML = xml.objectDescription[0];
			
			_name = name;
			_wrapperManager = wm;
			_wrappedObj = createObject(objXml, parent);
			
			findMethods();
			
			var codeXml:XML = xml.code[0];
			var i:int;

			_codeXml = <code/>;
			var segments:XMLList = codeXml.children();
			for(i = 0; i < segments.length(); ++i){
				parseCode(segments[i]);
			}
		}
		
		/**
		 * Using the mx.utils.describeType() method, produce a Dictionary of all methods that this object has. The
		 * name of the method is the key, and the value is xml that describes the parameters
		 **/
		private function findMethods():void{
			var typeXML:XML = describeType(_wrappedObj);
			var xml:XML;
			var str:String;
			for each(xml in typeXML.method){
				str = xml.@name;
				_methodXmlDict[str] = xml;
			}			
		}
		
		
		/**
		 * Pass in an a multipart argument to set a property or method. For example,
		 * setArgument("label", "My New Label") will set the label property (if it exists) to "My New Label"
		 **/
		public function setArgument(... args):void{
			var argArray:Array = args as Array;
			setArgArray(argArray);
		}
		
		/**
		 * Pass in an a multipart argument to set a property or method as an array. For example,
		 * setArgument(args), where args[0] = "label" and arg[1] = "My New Label" will set the label 
		 * property (if it exists) to "My New Label"
		 **/
		public function setArgArray(argArray:Array):void{
			var argName:String = argArray.shift();
			var func:Function;

			// Look to see if this object has a function named [argName]. If it does,
			// then execute the function with the argArray. 
			if(_methodXmlDict.hasOwnProperty(argName)){
				func = _wrappedObj[argName] as Function;
				func.apply(this, argArray);

			}
			else if(_wrappedObj.hasOwnProperty(argName)){
				_wrappedObj[argName] = argArray[0];
			}			
		}
		
		/**
		 * Get the DisplayObject that we wrap
		 **/
		public function getDisplayObject():DisplayObject{
			return _wrappedObj;
		}
		
		/**
		 * Get the DisplayObject that we wrap if it is a Container
		 **/
		public function getContainer():Container{
			if(_wrappedObj is Container){
				return _wrappedObj as Container;
			}
			return null
		}
		
		/**
		 * Get the xml that describes this ObjectWrapper and all its children
		 **/
		public function get xml():XML{
			var retXml:XML = <wrappedObject/>;
			retXml.@name = _name;
			retXml.appendChild(getXmlDescription(_wrappedObj, _name));
			retXml.appendChild(_codeXml);
			return retXml;
		}
		
		/**
		 * Return the type information on the wrapped object:
		 * Returns XML — An XML object containing details about the object that was passed in as a parameter. It provides the following information about the object: 
		 * The class of the object
		 * The attributes of the class
		 * The inheritance tree from the class to its base classes
		 * The interfaces implemented by the class
		 * The declared instance properties of the class
		 * The declared static properties of the class
		 * The instance methods of the class
		 * The static methods of the class 
		 * For each method of the class, the name, number of parameters, return type, and parameter types 
		 * Note: describeType() only shows public properties and methods, and will not show properties and methods that are private, package internal or in custom namespaces. 
		 **/
		protected function get typeXml():XML{
			return describeType(_wrappedObj);
		}

		/**
		 * Create the DisplayObject from the xml description, and add it as a child to the parent. If this object has 
		 * children, then those opbjects are wrapped as well and added to the WrapperManager for this hierarchy.
		 **/
		protected function createObject(xml:XML, parent:Container):DisplayObject{
			var dispObj:DisplayObject;
			var _name:String = xml.@className;	
			var instance:Object = null;
			_logger.debug("className = "+_name);
			try{
				var ClassReference:Class = getDefinitionByName(_name) as Class;
	            instance = new ClassReference();			
				
				var propXml:XML;
				for each(propXml in xml.property){
					try{
						instance[propXml.@name] = propXml.@value;
						//trace(propXml.@name+" = "+propXml.@value);
					}catch(error:ReferenceError){
						_logger.debug("ReferenceError: "+propXml.@name+" = "+propXml.@value);
					}catch(error:TypeError){
						_logger.debug("TypeError: "+propXml.@name+" = "+propXml.@value);
					}
				}
				var objXml:XML;
				for each(objXml in xml.wrappedObject){
					// we probably want to make another wrapper and add that to our children?
					_wrapperManager.wrapXml(objXml, Container(instance));
					//createObject(objXml, Container(instance));
				}
		
	            parent.addChild(DisplayObject(instance));	
	            return(DisplayObject(instance));
		   }catch(error:ReferenceError){
		   		_logger.debug(error.message);
		   }
		   _logger.error("unable to create wrapped object for: "+_name);
		   return (DisplayObject(instance));
		}
		
		/**
		 * Get the XML that describes this ObjectWrapper - essentially, we want this to be as close to a 
		 * true Serialize() function as possible
		 **/
		protected function getXmlDescription(obj:Object, name:String):XML{
			var xml:XML;
			var str:String;
			var propXml:XML;
			var retXml:XML = <objectDescription/>;
			
			xml = describeType(obj);
			str = xml.@name;
			str = str.replace("::", ".");
			retXml.@className = str;
			retXml.@name = name;
			
			var classInfo:Object = ObjectUtil.getClassInfo(obj);
			var array:Array = classInfo["properties"];
			var o:Object;
			for each(str in array){
				o = obj[str];
				if(o != null){
					xml = describeType(o);
					if(ObjectUtil.isSimple(o)){
						if(obj[str] == ""){continue;}
						if(str == "mouseX"){continue;}
						if(str == "mouseY"){continue;}
						if(str == "contentMouseX"){continue;}
						if(str == "contentMouseY"){continue;}
						if(str == "initialized"){continue;}
						if(xml.@name == "Array"){continue;}
						if(isNaN(obj[str])){
							if(obj[str] is Number){continue;}
							if(str == "uid"){continue;}

							//trace(str+" = "+obj[str]);
						}
						propXml = <property/>;
						propXml.@type = xml.@name;
						propXml.@name = str;
						propXml.@value = obj[str];
						retXml.appendChild(propXml);
					}else{
						//retXml.appendChild(getXmlDescription(o));
					}
				}
			}
			
			var children:Array;
			var dispObj:DisplayObject;
			var childWrapper:ObjectWrapper;
			if(obj.hasOwnProperty("getChildren")){
				children = obj.getChildren();
				for each(dispObj in children){
					childWrapper = _wrapperManager.getWrapper(dispObj.name);
					if(childWrapper == null){
						childWrapper = new ObjectWrapper();
						childWrapper.wrapDisplayObject(dispObj, dispObj.name, _wrapperManager);
					}
					retXml.appendChild(childWrapper.xml);
				}
			}
			
			

			return retXml;
		}
		
		/**
		 * Clear the code buffer of all accumulated actions stored by the parseCode() method.
		 **/
		public function clearCodeBuffer():void{
			_codeXml = <code/>;
		}
		
		/**
		 * Handles xml data description for (ObjectWrapper) wrapped (DisplayObject) objects.
		 * An example xml is shown below:
		 * 
		 *	<target objectName="_consoleText">
		 *		<string name = "text" value = "The slow brown fox jumped over the lazy dog's back!"/>
		 *		<method name = "setStyle">
		 *			<arg value = "backgroundColor"/>
		 *			<arg value = "#CCCCCC"/>
		 *		</method>
		 *		<method name = "setStyle">
		 *			<arg value = "fontSize"/>
		 *			<arg value = "30"/>
		 *		</method>
		 *	</target>
		 **/
		public function parseCode(propXml:XML):void{
			var o:Object;
			var prop:Object;
			var argXml:XML;
			//var propXml:XML;
			var propXmlList:XMLList;
			var name:String;
			var argArray:Array;
			
			var str:String;
			var num:Number;
			var u:uint;
			var i:int;
			var b:Boolean;
			var d:Date;
			var a:Array;
			
			_codeXml.appendChild(propXml);
			
			name = propXml.name();
			switch(name){

				case "string":
					name = propXml.@name;
					str = propXml.@value;
					setArgument(name, str);
					break;
				case "number":
					name = propXml.@name;
					num = new Number(propXml.@value);
					setArgument(name, num);
					break;
				case "uint":
					name = propXml.@name;
					u = propXml.@value;
					setArgument(name, u);
					break;
				case "int":
					name = propXml.@name;
					i = propXml.@value;
					setArgument(name, i);
					break;
				case "boolean":
					name = propXml.@name;
					b = propXml.@value;
					setArgument(name, b);
					break;
				case "date":
					name = propXml.@name;
					str = propXml.@value; 
					d = new Date(str); 
					setArgument(name, d);
					break;
				case "array":
					name = propXml.@name;
					a = new Array();
					propXmlList = propXml.children();
					for(i = 0; i < propXmlList.length(); ++i){
						o = parseTypeXml(propXmlList[i]);
						if(o != null){
							a.push(o);
						}
					}
					setArgument(name, a);
					break;
				case "object":
					name = propXml.@name;
					o = new Object();
					propXmlList = propXml.children();
					for(i = 0; i < propXmlList.length(); ++i){
						prop = parseTypeXml(propXmlList[i]);
						if(prop != null){
							str = propXmlList[i].@name;
							o[str] = prop;
						}
					}
					setArgument(name, o);
					break;
				case "method":
					name = propXml.@name;
					argArray = new Array();
					argArray.push(name);
					for each(argXml in propXml.arg){
						str = argXml.@value;
						argArray.push(str);
					}
					setArgArray(argArray);
					break;
			}
		}
			
		/**
		 * Handle XML in the form shown below:
		 * 
		 * <string name="myString" value="bar"/>
		 * <number name="myNumber" value="-3.1415"/>
		 * <uint name="myUint" value="64"/>
		 * <int name="myInt" value="-1"/>
		 * <boolean name="myBoolean" value="true"/>
		 * <date name="myDate" value = "Feb 15 1960"/>
		 * <array name="myArray">
		 * 	<int name = "myArrayElement1" value = "-5"/>
		 * 	<int name = "myArrayElement2" value = "-4"/>
		 * 	<int name = "myArrayElement3" value = "-3"/>
		 * 	<int name = "myArrayElement4" value = "-2"/>
		 * 	<int name = "myArrayElement5" value = "-1"/>
		 * </array>
		 * <object name="myObject">
		 *  <string name="myString" value="bar"/>
		 *  <number name="myNumber" value="-3.1415"/>
		 *  <uint name="myUint" value="64"/>
		 *  <int name="myInt" value="-1"/>
		 *  <boolean name="myBoolean" value="true"/>
		 *  <date name="myDate" value = "Feb 15 1960"/>
		 * </array>
		 **/
		protected function parseTypeXml(xml:XML):Object{
			var type:String = xml.name();
			var name:String = xml.@name;
			var propXmlList:XMLList;
			var o:Object;
			var prop:Object;
			var str:String;
			var num:Number;
			var u:uint;
			var i:int;
			var b:Boolean;
			var d:Date;
			var a:Array;
			
			switch(type.toLowerCase()){
				case "string": str = xml.@value; return str;
				case "number": num = new Number(xml.@value); return num;
				case "uint": u = xml.@value; return u;
				case "int": i = xml.@value; return i;
				case "boolean": b = xml.@value; return b;
				case "date": 
					str = xml.@value; 
					d = new Date(str); 
					return d;
				case "array": 
					a = new Array();
					propXmlList = xml.children();
					for(i = 0; i < propXmlList.length(); ++i){
						o = parseTypeXml(propXmlList[i]);
						if(o != null){
							a.push(o);
						}
					}
				return a;
				case "object": 
					o = new Object();
					propXmlList = xml.children();
					for(i = 0; i < propXmlList.length(); ++i){
						prop = parseTypeXml(propXmlList[i]);
						if(prop != null){
							str = propXmlList[i].@name;
							o[str] = prop;
						}
					}
				return o;
			}	
			return null;
		}
			
					
		// This exists to make sure getDefinitionByName() works
		private  function pingCompiler():void{
			// Controls
			var adg:AdvancedDataGrid;
			var adgx:AdvancedDataGridBaseEx;
			var alert:Alert;
			var b:Button;
			var bb:ButtonBar;
			var blp:ButtonLabelPlacement;
			var cb:CheckBox;
			var cp:ColorPicker;
			var comboBase:ComboBase;
			var comboBox:ComboBox;
			var dg:DataGrid;
			var dc:DateChooser;
			var df:DateField;
			var fil:FormItemLabel;
			var hl:HorizontalList;
			var hr:HRule;
			var hsb:HScrollBar;
			var hs:HSlider;
			var img:Image;
			var lbl:Label;
			var lb:LinkBar;
			var lbut:LinkButton;
			var list:List;
			var mn:Menu;
			var mb:MenuBar;
			var nb:NavBar;
			var ns:NumericStepper;
			var olap:OLAPDataGrid;
			var popb:PopUpButton;
			var prog:ProgressBar;
			var rb:RadioButton;
			var rbg:RadioButtonGroup;
			var rte:RichTextEditor;
			var s:Spacer;
			var swfl:SWFLoader;
			var tb:TabBar;
			var txt:Text;
			var ta:TextArea;
			var ti:TextInput;
			var tl:TileList;
			var tog:ToggleButtonBar;
			var tt:ToolTip;
			var tree:Tree;
			var vd:VideoDisplay;
			var vr:VRule;
			var vsb:VScrollBar;
			var vs:VSlider;
			
			//Containers
			var acc:Accordion;
			var acb:ApplicationControlBar;
			var box:Box;
			var boxd:BoxDirection;
			var c:Canvas;
			var ctrlb:ControlBar;
			var divb:DividedBox;
			var form:Form;
			var formh:FormHeading;
			var formi:FormItem;
			var formid:FormItemDirection;
			var grid:Grid;
			var gridi:GridItem;
			var gridr:GridRow;
			var hbox:HBox;
			var panel:Panel;
			var tabn:TabNavigator;
			var tile:Tile;
			var tiled:TileDirection;
			var tw:TitleWindow;
			var views:ViewStack;
		}
	}
}