package com.edgeti.EdgeUtils.layout.managers
{
	import com.edgeti.EdgeUtils.DynamicPanel.DynamicPanel;
	import com.edgeti.EdgeUtils.DynamicPanel.PanelEvent;
	
	import flash.events.EventDispatcher;
	
	import mx.collections.ArrayCollection;
	import mx.containers.Canvas;
	import mx.core.UIComponent;
	import mx.effects.Move;
	import mx.effects.Parallel;
	import mx.effects.Resize;
	import mx.effects.easing.Exponential;
	import mx.events.CollectionEvent;
	import mx.events.CollectionEventKind;
	import mx.events.EffectEvent;
	import mx.events.ResizeEvent;

	public class LayoutManagerBase extends EventDispatcher
	{
		public var name:String = "Base Class";
		
		protected var _view:Canvas;
		protected var _parallel:Parallel;
		
		function LayoutManagerBase(view:Canvas)
		{
			_view = view;
			
			_view.addEventListener(ResizeEvent.RESIZE, onContainerResize);
		}
		
		// Abstract. Applies and creates the layout for a layout manager.
		public function applyLayout(animate:Boolean):void{}
	
		protected function onEffectEnd(e:EffectEvent):void
		{
			dispatchEvent(e);
		}
		
		// Returns whether or not the main transition is occurring.
		public function get transitioning():Boolean
		{
			return _parallel == null ? false : _parallel.isPlaying;
		}
		
		public function stopTransition():void
		{
			if (_parallel != null)
				_parallel.pause(); // Don't call end() otherwise effectEnd will fire.
		}
		
		//************************************
		// Common Animations
		//************************************
		
		protected function createMoveEffectInstance(uiComponent:UIComponent, targetX:Number, targetY:Number):Move
		{
			var move:Move;
			if (uiComponent.x != targetX || uiComponent.y != targetY) // Only create a Move effect if the x, y has changed.
			{
				move = new Move(uiComponent);
				move.easingFunction = Exponential.easeOut;
				move.xTo = targetX;
				move.yTo = targetY;
			}
			
			return move;
		}
		
		protected function createResizeEffectInstance(uiComponent:UIComponent, targetW:Number, targetH:Number):Resize
		{
			var resize:Resize;
			//if (uiComponent.width != targetW || uiComponent.height != targetH) // Only create a Resize if needed.
			{
				var wTo:Number = targetW;
				var hTo:Number = targetH;
				
				if (uiComponent is DynamicPanel){
					var panel:DynamicPanel = uiComponent as DynamicPanel;
					if (wTo < DynamicPanel.MIN_WIDTH){
						wTo = DynamicPanel.MIN_WIDTH;
					}
					if (hTo < DynamicPanel.MIN_HEIGHT){
						hTo = DynamicPanel.MIN_HEIGHT;
					}
				}
				
				resize = new Resize(uiComponent);
				resize.easingFunction = Exponential.easeOut;
				resize.widthTo = wTo;
				resize.heightTo = hTo;
			}
			
			return resize;
		}
		
		//************************************
		// Managed Items
		//************************************
		
		[Bindable]
		protected var _items:ArrayCollection;
		
		[Bindable]
		public function set items(val:ArrayCollection):void{
			var panel:DynamicPanel;
			
			if (_items){
				_items.removeEventListener(CollectionEvent.COLLECTION_CHANGE, onCollectionChange);
				for each (panel in _items){
					removePanelListeners(panel);
				}
			}
			
			if (val){
				_items = val;
				_items.addEventListener(CollectionEvent.COLLECTION_CHANGE, onCollectionChange);
				for each (panel in _items){
					addPanelListeners(panel);
				}
			}
			
			//applyLayout(true);
		}
		
		public function get items():ArrayCollection{
			return _items;
		}
		
		//************************************
		// Managed Items Changes
		//************************************
		
		protected function onCollectionChange(evt:CollectionEvent):void{
			switch (evt.kind){
				case CollectionEventKind.ADD:
					//Item was added
					onItemAdd(evt.items, evt.location);
					break;
				case CollectionEventKind.REMOVE:
					//Item was removed
					onItemRemove(evt.items, evt.location);
					break;
				case CollectionEventKind.RESET:
					//Drastic change, reapply layout
					onItemReset();
					break;
					
					
				case CollectionEventKind.REPLACE:
					//A single item was swapped out, this should never happen
				case CollectionEventKind.REFRESH:
					//Sort/Filter was applied, this should never happen
				case CollectionEventKind.MOVE:
					//An item switched z-order, don't care for now
				case CollectionEventKind.UPDATE:
					//Don't care
					break;
			}
		}
		
		protected function onItemAdd(items:Array, location:int):void{
			for each (var item:DynamicPanel in items){
				addPanelListeners(item);
			}
		
		}
		
		protected function onItemRemove(items:Array, location:int):void{
			for each (var item:DynamicPanel in items){
				removePanelListeners(item);
			}
		}
		
		protected function onItemReset():void{}
		
		
		protected function addPanelListeners(panel:DynamicPanel):void{
			panel.addEventListener(PanelEvent.MINIMIZE, onPanelMinimize, false, 0, true);
			panel.addEventListener(PanelEvent.MAXIMIZE, onPanelMaximize, false, 0, true);
			panel.addEventListener(PanelEvent.DEFAULT, onPanelRestore, false, 0, true);
			panel.addEventListener(PanelEvent.CLOSE, onPanelClose, false, 0, true);
		}
		
		protected function removePanelListeners(panel:DynamicPanel):void{
			panel.removeEventListener(PanelEvent.MINIMIZE, onPanelMinimize);
			panel.removeEventListener(PanelEvent.MAXIMIZE, onPanelMaximize);
			panel.removeEventListener(PanelEvent.DEFAULT, onPanelRestore);
			panel.removeEventListener(PanelEvent.CLOSE, onPanelClose);
		}
		
		//************************************
		// Minimized Items
		//************************************
		
		protected function onPanelMinimize(evt:PanelEvent):void{}
		
		protected function onPanelMaximize(evt:PanelEvent):void{}
		
		protected function onPanelRestore(evt:PanelEvent):void{}
		
		//************************************
		// Container Resize
		//************************************
		
		protected function onContainerResize(evt:ResizeEvent):void{}
		
		protected function getViewHeight():Number{
			var h:Number = _view.height;
			
			if (_view.horizontalScrollBar){
				h -=_view.horizontalScrollBar.height;
			}
			
			h = h / _view.scaleY;
			
			return h;
		}
		
		protected function getViewWidth():Number{
			var w:Number = _view.width;
			
			if (_view.verticalScrollBar){
				w -=_view.verticalScrollBar.width;
			}
			
			w = w / _view.scaleX;
			
			return w;
		}
		
		//************************************
		// Item Close
		//************************************
		
		protected function onPanelClose(evt:PanelEvent):void{
			var panel:DynamicPanel = evt.target as DynamicPanel;
			panel.dispose();
			_view.removeChild(panel);
		}
		
		//************************************
		// Focus Item
		//************************************
		
		public function focusPanel(panel:UIComponent):void{
			
		}
		
	}
}