package com.edgeti.EdgeUtils.layout.managers
{
	import mx.containers.Canvas;
	import mx.controls.scrollClasses.ScrollBar;

	/**
	 * This layout manager is an exact copy of VerticalScrollLayoutManager,
	 * however, a small space on the left is reserved for the QueryBuilder
	 * menu.
	 * **/
	public class BuilderLayoutManager extends VerticalScrollLayoutManager
	{
		//Space on the left reserved for the QueryBuilder
		protected var _reservedWidth:Number = 0;
		
		public function set reservedWidth(value:Number):void{
			_reservedWidth = value;
			
			applyLayout(true);
		}
		
		public function BuilderLayoutManager(view:Canvas)
		{
			super(view);
			
			name = "Cascade";
		}
		
		override protected function getViewWidth():Number{
			//Almost guaranteed to have scroll bars in this layout,
			//so always include them in the layout
			var containerWidth:Number = _view.width - ScrollBar.THICKNESS - _reservedWidth;
			
			containerWidth = containerWidth / _view.scaleX;
			
			//this is run during every applyLayout which makes it
			//a perfect time to update _leftOffset based on scale
			_leftOffset = _reservedWidth / _view.scaleX;
			
			return containerWidth;
		}
		
	}
}