package com.edgeti.EdgeUtils.general
{
	public class XmlUtils
	{
		public function XmlUtils()
		{
		}
		
		/**
		 * Set the given attribute to the provided value in an XML element. If this has child elements, do this too
		 **/
		public static function setXmlBranchAttribute(xml:XML, name:String, value:String):void{
			// set the value
			xml.@[name] = value;
			// set the value on children as well
			var children:XMLList = xml.children();
			var i:int;
			for(i = 0; i < children.length(); ++i){
				setXmlBranchAttribute(children[i], name, value);
			}
		}
		
		/**
		 * Set the given attribute to the provided value in an XML element. If this has a parent, do this too
		 **/
		public static function setXmlParentAttribute(xml:XML, name:String, value:String):void{
			// set the value
			xml.@[name] = value;
			// set the value on the parent as well
			var parent:XML;
			if(xml.parent() != null){
				parent = xml.parent() as XML;
				setXmlParentAttribute(parent, name, value);
			}
		}
		
		/**
		 * Look up the tree to see if there is an element with the attribute name
		 **/
		public static function findXmlParentWithAttributeValue(xml:XML, attrName:String, attrValue:String):XML{
			if(xml.@[attrName] == attrValue){
				return xml;
			}
			
			var parent:XML;
			if(xml.parent() == null){
				return null;
			}
			
			parent = xml.parent() as XML;
			return findXmlParentWithAttributeValue(parent, attrName, attrValue);
		}
	}
}