package com.edgeti.EdgeUtils.general
{
	public class StringUtils
	{
		public function StringUtils()
		{
		}
		
		public static function replaceAll( original:String, replace:String, replace_with:String):String
		{
			var array:Array = original.split(replace);
			return array.join(replace_with);
		}
		
		//********************************************
		// Date Functions
		//********************************************
		
		protected static var MONTHS:Array = ["jan","feb", "mar","apr","may","jun","jul","aug","sep","oct","nov","dec"];
		
		public static function isDate(value:String):Boolean{
			return parseDate(value) > 0;
		}
		
		/**
		 * Attempts to parse an object to a Date object then return then number
		 * of milliseconds since Jan 1, 1970.  First the object is passed to
		 * the native Date class which attempts to parse it.  If that fails,
		 * assume an incomplete date string has been passed in and look for
		 * a month and year.
		 * 
		 * If a year exists (YYYY), use that, otherwise assume the current year.
		 * If a month exsists (MMM), use that, otherwise assume the current month.
		 * And, for now, always assume first day of the month.
		 * 
		 * return number of milliseconds since Jan 1, 1970, or -1 for unknown date
		 * **/
		public static function parseDate(value:Object):Number{
			var temp:Number = Date.parse(value);
			if (temp > 0){
				return temp;
			}
			if (value is String){
				var dateString:String = (value as String).toLowerCase();
				
				//Try some other options...
				var findAnythin:Boolean = false;
				var pattern:RegExp;
				var index:int = -1;
				
				//Year (YYYY)
				var year:Number = new Date().fullYear;
				pattern = /\d\d\d\d/;
				index = dateString.search(pattern);
				if (index > -1){
					year = Number(dateString.slice(index, index+4));
					findAnythin = true;
				}
				
				//Month
				var month:Number = new Date().month;
				for (var i:int=0; i<12; ++i){
					index = dateString.search(MONTHS[i]);
					if (index > -1){
						month = i;
						findAnythin=true;
						break;
					}
				}
				
				//Assume first day of the month
				if (findAnythin){
					var parsedDate:Date = new Date(year, month, 1);
					return parsedDate.time;
				}
			}
			
			
			
			return -1;
		}
	}
}