package com.edgeti.EdgeUtils.general
{
	import flash.utils.Dictionary;
	import flash.utils.getQualifiedClassName;
	
	import com.edgeti.EdgeUtils.logger.Logger;
	
	/**
	 * Class for storing information as key/value pairs that is accessable anywhere within an application.
	 * Each item is stored as a DataElement in a static (Singleton) Dictionary. If an item is requested before
	 * it has been created, a placeholder DataElement is created with an Object as the data. Later, when the
	 * data publisher sets the data, the DataDictionary will point to the correct data.
	 *
	 * Each element in the DataDictionary can have a list of listener callback functions that can be called by
	 * accessing the DataDictionary.callListeners("dataName") method. The callback function needs to bein the form:
	 *
	 * function myFunction(nameString:String):void
	 *
	 * The string that is passed in is the name of the data. This way, if you wish to have a single callback that
	 * handles multiple data, you can select actions based on the name.
	 *
	 * Copyright 2010 FGM Inc
	 *
	 * Author: Phil Feldman
	 **/
	public class SingletonDataDictionary
	{
		private static var _dict:Dictionary = null;
		
		public function SingletonDataDictionary()
		{
		}
		
		public static function get dict():Dictionary{
			if(_dict == null){
				_dict = new Dictionary();
			}
			return _dict;           
		}
		
		/**
		 * Indicates whether an object has a specified property defined. This method
		 * returns true if the target object has a property that matches the string
		 * specified by the name parameter, and false otherwise. Once the data has been
		 **/
		public static function hasOwnProperty(name:*, namespace:String=null):Boolean{
			
			var fullname:String = namespace == null ? name : namespace+"::"+name;
			
			return _dict.hasOwnProperty(fullname);
		}
		
		/**
		 * Add an item to the DataDictionary.
		 **/
		public static function addItem(name:String, data:*, namespace:String=null):void{
			var typeString:String;
			
			var di:DataElement = getItem(name, namespace);
			if(di.type == "unset"){
				di.type = getQualifiedClassName(data);
			}
			di.data = data;
			di.callListeners();
		}
		
		/**
		 * Sets the value of an item in the data dictinoary. This is a convenience
		 * method that simply calls addItem
		 **/
		public static function setItem(name:String, data:*, namespace:String=null):void{
			addItem(name, data, namespace);
		}
		
		/**
		 * Get the DataElement that contians the desired data item. If the item does not exist,
		 * an entry is created using a dummy object and returned. If the item is later set using
		 * addItem() or setItem(), the data will be replaced
		 **/
		public static function getItem(name:String, namespace:String=null):DataElement{
			var di:DataElement;
			
			var fullname:String = namespace == null ? name : namespace+"::"+name;
			
			if(dict.hasOwnProperty(fullname)){
				di = dict[fullname];
			}else{
				di = new DataElement(name, "unset", new Object(), namespace);
				var logger:Logger = Logger.getLogger();
				logger.warn("SingletonDataDictionary.getItem(): retrieving unset item with key "+fullname);
			}
			dict[fullname] = di;
			return di;
		}
		
		/**
		 * Get the data item that is contained within a DataElement. If the item does not exist,
		 * an entry is created using a dummy object and returned. If the item is later set using
		 * addItem() or setItem(), the data will be replaced
		 **/       
		public static function getItemData(name:String, namespace:String=null):*{
			var di:DataElement = getItem(name, namespace);
			return di.data;
		}
		
		/**
		 * clear all elements from the DataDictionary
		 **/
		public static function clear():void{
			_dict = null;
		}
		
		/**
		 * Add a listener callback function to a particular data item The callback function needs to bein the form:
		 *
		 * function myFunction(nameString:String, data:*):void
		 *
		 * The string that is passed in is the name of the data. This way, if you wish to have a single callback that
		 * handles multiple data, you can select actions based on the name.
		 **/
		public static function addListener(name:String, callback:Function, namespace:String=null):void{
			var di:DataElement = getItem(name,namespace);
			di.addListener(callback);
		}
		
		/**
		 * Have the named DataElement call all the registered callback functions
		 **/
		public static function callListeners(name:String, namespace:String=null):void{
			var di:DataElement = getItem(name, namespace);
			di.callListeners();
		}
	}
}
