package com.edgeti.EdgeUtils.general
{
	import mx.binding.utils.ChangeWatcher;
	import mx.collections.ArrayCollection;
	import mx.collections.ArrayList;
	
	/**
	 * Class used to create elements that are stored in the DataDictionary. For more information about behavior,
	 * see the DataDictionary documentation
	 *
	 * Copyright 2010 FGM Inc
	 *
	 * Author: Phil Feldman
	 **/
	public class DataElement
	{
		private var _name:String;
		private var _namespace:String;
		private var _type:String;
		private var _data:*;
		private var _listenerList:ArrayCollection;
		
		/**
		 * Create a DataElement.
		 * name is the key value
		 * type is a string storing the qualified type string for use in reflection
		 * data is the value to be stored
		 **/
		public function DataElement(name:String, type:String, data:*, namespace:String=null)
		{
			_name = name;
			_namespace = namespace;
			_type = type;
			_data = data;
			_listenerList = new ArrayCollection();
		}
		
		/**
		 * Return the name of the data
		 **/
		public function get name():String{
			return _name;
		}
		
		/**
		 * Return the type of the data
		 **/
		public function get type():String{
			return _type;
		}
		
		/**
		 * Return the data value
		 **/
		public function get data():*{
			return _data;
		}
		
		/**
		 * Set the qualified type string
		 **/
		public function set type(str:String):void{
			_type = str;
		}
		
		/**
		 * Set the data value
		 **/
		public function set data(o:*):void{
			_data = o;
		}
		
		/**
		 * Add a listener callback function. the function must be in the form:
		 * function myFunction(name:String, value:*):void
		 *
		 * The same callback can only be added once regardless of how often this is called
		 **/
		public function addListener(callback:Function):void{
			if(_listenerList.getItemIndex(callback) == -1){
				_listenerList.addItem(callback);
			}
		}
		
		/**
		 * Remove a listener callback function
		 **/
		public function removeListener(callback:Function):void{
			var index:int = _listenerList.getItemIndex(callback)
			if(index != -1){
				_listenerList.removeItemAt(index);
			}			
		}
		
		/**
		 * Have all the 'subscribed' callback functions to this DataElement be called
		 **/
		public function callListeners():void{
			var fcn:Function;
			for each(fcn in _listenerList){
				fcn(_name, _data);
			}
		}
	}
}