package com.edgeti.EdgeUtils.color
{
	import mx.graphics.SolidColor;

	public class HsbObject
	{
		protected var red:Number;
		protected var green:Number, blue:Number;
		protected var hue:Number;
		protected var saturation:Number;
		protected var brightness:Number;
		protected var hexColor:uint;
		
		public function HsbObject(hexC:uint = 0)
		{
			setFromHexcolor(hexC);
			

		}
		
		public function setFromHexcolor(hexC:uint):void{
			var r1:uint;
			var g1:uint;
			var b1:uint;
			var c1:uint = hexC;
			
			// strip off red
			r1 = c1/0x10000;
			c1 = c1 - (r1*0x10000);
			
			// strip off green
			g1 = c1/0x100;
			c1 = c1 - (g1*0x100);
			
			// blue is all that's left
			b1 = c1;
			
			setFromRGB(r1, g1, b1);
		}
		
		/**
		 * Returns an Hue/Saturation/Brightness object with Number values for h, s, and b
		 * h ranges from 0 - 360
		 * s ranges from 0 - 100
		 * b ranges from 0 - 100
		 **/
		public function setFromRGB(r:int, g:int, b:int):void
		{
			red = r;
			green = g;
			blue = b;
			
			var _max:Number = Math.max(r,g,b);
			var _min:Number = Math.min(r,g,b);
			
			saturation = (_max != 0) ? (_max - _min) / _max * 100: 0;
			brightness = _max / 255 * 100;
			
			if(saturation == 0){
				hue = 0;
			}else{
				switch(_max)
				{
					case r:
						hue = (g - b)/(_max - _min)*60 + 0;
						break;
					case g:
						hue = (b - r)/(_max - _min)*60 + 120;
						break;
					case b:
						hue = (r - g)/(_max - _min)*60 + 240;
						break;
				}
			}
			
			hue = Math.min(360, Math.max(0, Math.round(hue)));
			saturation = Math.min(100, Math.max(0, Math.round(saturation)));
			brightness = Math.min(100, Math.max(0, Math.round(brightness)));
				
			hexColor = uint(red)*0x10000 + uint(green)*0x100 + uint(blue);
		}
		
		/**
		 * Returns a Red/Green/Blue object with Number values for r, g, and b
		 * r, g, b ranges from 0 - 255
		 **/
		public function setFromHSB(h:int, s:int, b:int):void
		{
			var max:Number = (b * 0.01) * 255;
			var min:Number = max * (1 - (s * 0.01));
			
			hue = h%360; // make sure this works
			saturation = s;
			brightness = b;
			
			if (s == 0) {
				red = green = blue = blue*(255*0.01) ;
			} else {
				var _h:Number = Math.floor(h / 60);
				
				switch(_h){
					case 0:
						red = max	;
						green = min+h * (max-min)/ 60;
						blue = min;
						break;
					case 1:
						red = max-(h-60) * (max-min)/60;
						green = max;
						blue = min;
						break;
					case 2:
						red = min ;
						green = max;
						blue = min+(h-120) * (max-min)/60;
						break;
					case 3:
						red = min;
						green = max-(h-180) * (max-min)/60;
						blue =max;
						break;
					case 4:
						red = min+(h-240) * (max-min)/60;
						green = min;
						blue = max;
						break;
					case 5:
						red = max;
						green = min;
						blue = max-(h-300) * (max-min)/60;
						break;
					case 6:
						red = max;
						green = min+h * (max-min)/ 60;
						blue = min;
						break;
				}
				
				red = Math.min(255, Math.max(0, Math.round(red)));
				green = Math.min(255, Math.max(0, Math.round(green)));
				blue = Math.min(255, Math.max(0, Math.round(blue)));
					
				hexColor = uint(red)*0x10000 + uint(green)*0x100 + uint(blue);
			}
		}
		
		public function rotateHue(angle:Number):void{
			var iHue:int = int(Math.round(hue));
			var iAngle:int = int(Math.round(angle));
			
			iHue += iAngle;
			iHue = iHue % 360;
			
			setFromHSB(iHue, saturation, brightness);
		}
		
		public function modifySaturation(delta:int):void{
			saturation += delta;
			saturation = Math.max(0, saturation);
			saturation = Math.min(255, saturation);
			setFromHSB(hue, saturation, brightness);
		}
		
		public function setFloorSaturation(val:int):void{
			if(saturation < val){
				saturation = val;
				saturation = Math.max(0, saturation);
				saturation = Math.min(255, saturation);
				setFromHSB(hue, saturation, brightness);
			}
		}

		
		public function getHexColor():uint{
			return hexColor;
		}
		
		public function getRed():uint{
			return uint(Math.round(red));
		}
		
		public function getGreen():uint{
			return uint(Math.round(green));
		}
		
		public function getBlue():uint{
			return uint(Math.round(blue));
		}
		
		public function getHue():uint{
			return uint(Math.round(hue));
		}
		
		public function getSaturation():uint{
			return uint(Math.round(saturation));
		}
		
		public function getBrightness():uint{
			return uint(Math.round(brightness));
		}
		
		public function getSolidColor():SolidColor{
			return new SolidColor(hexColor, 1.0);
		}
	}
}