package com.edgeti.EdgeUtils.color
{
	import mx.charts.ChartItem;
	import mx.graphics.IFill;
	import mx.graphics.SolidColor;
	import mx.styles.CSSStyleDeclaration;
	import mx.styles.StyleManager;

	public final class ColorUtil
	{
	
	    /**
	     * Converts an integer (hex) value to an object with separate r, g, 
	     * and b elements.
	     */
	    public static function intToRgb( color:int ):Object
	    {
	        var r:int = ( color & 0xFF0000 ) >> 16;
	        var g:int = ( color & 0x00FF00 ) >> 8;
	        var b:int = color & 0x0000FF;
	        return {r:r, g:g, b:b};
	    }
		
		public static function getSchemeColor(c1:uint , c2:uint , index:uint ):SolidColor {
			
			var hsb1:HsbObject = new HsbObject(c1);
			var hsb2:HsbObject = new HsbObject(c2);
			hsb1.setFloorSaturation(20);
			hsb2.setFloorSaturation(20);
			
			var hue1:uint = hsb1.getHue();
			var hue2:uint = hsb2.getHue();
			var hueDelta:Number = Math.abs(hue1 - hue2);
			hueDelta = Math.max(21, hueDelta);
			hueDelta = Math.min(5, hueDelta);
			
			if(hue1 > hue2){
				hsb1.rotateHue(hueDelta*index);
				return hsb1.getSolidColor();
			}
			
			hsb2.rotateHue(hueDelta*index);
			return hsb2.getSolidColor();
		}
		
		public static function setSeriesColor(element:ChartItem, index:Number):IFill {
			var cssDecl:CSSStyleDeclaration;
			cssDecl = StyleManager.getStyleDeclaration(".Series1");		
			var o1:XMLList = cssDecl.getStyle("fill") as XMLList;
			
			cssDecl = StyleManager.getStyleDeclaration(".Series2");		
			var o2:XMLList = cssDecl.getStyle("fill") as XMLList;
			
			var c:SolidColor;

			var n1:Number;
			var n2:Number;

			n1 = parseInt(o1[0], 10);
			n2 = parseInt(o2[0], 10);
			c = getSchemeColor(uint(n1), uint(n2), index);				
			
			
			return c;
			
		}
	    
	}
}