package com.edgeti.EdgeUtils
{
	import com.edgeti.EdgeUtils.logger.Logger;
	import com.edgeti.RemoteClasses.FlexTreeObject;
	
	import flash.display.DisplayObject;
	import flash.system.Capabilities;
	import flash.utils.Dictionary;
	
	import mx.collections.ArrayCollection;
	import mx.containers.Panel;
	import mx.controls.Alert;
	import mx.core.Application;
	import mx.events.ValidationResultEvent;
	import mx.validators.Validator;
	
	public class Utils
	{
		protected static var logger:Logger = Logger.getLogger();
		
		public function Utils()
		{
		}
		
		public static function checkResolution(appName:String, desiredx:int, desiredy:int):void{
			    var xres:Number = Capabilities.screenResolutionX;
            	var yres:Number = Capabilities.screenResolutionY;
            	var name:String = "This application";
            	if(appName != null){
            		name = appName;
            	}
            	if((xres < desiredx)||(yres < desiredy)){
            		Alert.show(name+" functions best when running at a resolution of "+desiredx+" X "+desiredy+" or higher. Your settings are currently "+xres+" X "+yres+". Please adjust your display settings if possible.", "Screen Resolution");
            	} 
		}
		
		public static function findPanelByTitle(title:String):Panel{
			var app:Application = Application.application as Application;
			var widgets:Array = app.getChildren();
			var i:int;
			var panel:Panel;
			
			for(i = 0; i < widgets.length; ++i){
				if(widgets[i] is Panel){
					panel = widgets[i];
					if(panel.title == title){
						return panel;
					}
				}
			}
			return null;
		}
		
		public static function removeComponentFromApp(displayObject:DisplayObject):void{
			if(displayObject == null){
				logger.warn("Tried to remove a null DisplayObject");
				return;
			}
			var app:Application = Application.application as Application;
			app.removeChild(displayObject);
		}
		
		public static function validateString(val:Validator, obj:Object, text:String):Boolean{
			var vResult:ValidationResultEvent;

			val.listener = obj;
			vResult = val.validate(text);
			return(vResult.type == ValidationResultEvent.VALID);			
		}
		
		public static function buildTree(seperator:String, index:int, nameList:ArrayCollection, root:FlexTreeObject):void{
				if(nameList.length == 0){
					logger.warn("branch: "+root.fullName+", nameList length is zero");
					return;
				}
				var child:FlexTreeObject;
				var str:String;
				var fullStr:String;
				var subStrs:Array;
				var i:int;
				// go through the nameList and build the putative roots. Those that have only one child will
				// get rolled up into a leaf node in the next step
				//logger.debug("branch: "+root.fullName);
				for each(fullStr in nameList){
					str = fullStr;
					if(fullStr.indexOf(seperator) != -1){
						subStrs = fullStr.split(seperator);
						str = subStrs[0];
						for(i = 1; i <=  index; ++i){
							if(subStrs[i] == undefined){
								break;
							}
							str += "_"+subStrs[i];
						}
					}
					if(str != root.label){
						child = new FlexTreeObject(str);
						root.addUniqueChild(child);
					}else{ // special case, where there is a branch also happens to be a header
						if(root.parent.label != str){
							child = new FlexTreeObject(str);
							root.addUniqueChild(child);
						}
					}
				}
				
				i = 0;
				var subList:ArrayCollection = new ArrayCollection();
				for each(child in root.children){
					subList.removeAll();
					for each(fullStr in nameList){
						if(fullStr.indexOf(child.label+seperator) == 0){
							subList.addItem(fullStr);
						} else if(fullStr == child.label){
							subList.addItem(fullStr);
						}
					}
					if(subList.length == 1){ // if there is only one child, then don't build a tree
						child.label = subList.getItemAt(0) as String;
					}else if(root.label == child.label){ // special case, where there is a branch that also happens to be a header
						child.label = subList.getItemAt(i) as String;
					}else{ // we have more branches to descend
						buildTree(seperator, index+1, subList, child);
					}
					++i
				}
				
				// eliminate redundant entries that are common to the children of this FTO and the 
				// children of the children of this FTO
				
				// place all the leaf nodes (no children) in a dictionary, so we can hash by label
				var dict:Dictionary = new Dictionary();
				for each (child in root.children){
					if(child.children == null){ // leaf nodes
						dict[child.label] = child;
					}
				}
				
				// go through all the branch node's children and see if the dictionary has a
				// property that matches. if so, remove the child
				var subChild:FlexTreeObject;
				for each (child in root.children){
					if(child.children != null){ // branch nodes
						for each(subChild in child.children){
							if(dict.hasOwnProperty(subChild.label)){
								root.removeChild(dict[subChild.label]);
							}
						}
					}
				}
			}
			
		/**
		 * Set the given attribute to the provided value in an XML element. If this has child elements, do this too
		 **/
		public static function setXmlBranchAttribute(xml:XML, name:String, value:String):void{
			// set the value
			xml.@[name] = value;
			// set the value on children as well
			var children:XMLList = xml.children();
			var i:int;
			for(i = 0; i < children.length(); ++i){
				setXmlBranchAttribute(children[i], name, value);
			}
		}
		
		/**
		 * Set the given attribute to the provided value in an XML element. If this has a parent, do this too
		 **/
		public static function setXmlParentAttribute(xml:XML, name:String, value:String):void{
			// set the value
			xml.@[name] = value;
			// set the value on the parent as well
			var parent:XML;
			if(xml.parent() != null){
				parent = xml.parent() as XML;
				setXmlParentAttribute(parent, name, value);
			}
		}
		
		/**
		 * Look up the tree to see if there is an element with the attribute name
		 **/
		public static function findXmlParentWithAttributeValue(xml:XML, attrName:String, attrValue:String):XML{
			if(xml.@[attrName] == attrValue){
				return xml;
			}
			
			var parent:XML;
			if(xml.parent() == null){
				return null;
			}
			
			parent = xml.parent() as XML;
			return findXmlParentWithAttributeValue(parent, attrName, attrValue);
		}
		
		/*****
		public static function replaceAll(raw:String, pattern:Object, repl:Object):String{
			var text:String = raw.replace(pattern, repl);
			while(text.search(pattern) != -1){
				text = text.replace(pattern, repl);
			}
			return text;
		}
		/****/
		public static function replaceAll( original:String, replace:String, replace_with:String):String
		{
			var array:Array = original.split(replace);
			return array.join(replace_with);
		}
		
		
		
		//********************************************
		// Graphics Functions
		//********************************************
		
		/**
		 * Returns a UINT color based on the string value
		 **/
		public static function stringToColor(candidate:String):int{
			
			var str:String = candidate.toLowerCase();
			
			if(str.indexOf("error") != -1){
				return 0xFF0000;
			} else if(str.indexOf("critical") != -1){
				return 0xFF0000;
			} else if(str.indexOf("refused") != -1){
				return 0xFF0000;
			} else if(str.indexOf("unauthorized") != -1){
				return 0xFF0000;
			} else if(str.indexOf("hijacked") != -1){
				return 0xFF0000;
			} else if(str.indexOf("warning") != -1){
				return 0xFFFF00;
			}else if(str.indexOf("normal") != -1){
				return 0x00FF00;
			}else if(str.indexOf("ok") != -1){
				return 0x00FF00;
			}else if(str.indexOf("success") != -1){
				return 0x00FF00;
			}else if(str.indexOf("found") != -1){
				return 0x00FF00;
			}else if(str.indexOf("dead") != -1){
				return 0x000000;
			}else if(str.indexOf("forbidden") != -1){
				return 0x000000;
			}else if(str.indexOf("offline") != -1){
				return 0xAAAAAA;
			}else if(str.indexOf("unknown") != -1){
				return 0xAAAAAA;
			}else if(str.indexOf("red") != -1){
				return 0xFF0000;
			}else if(str.indexOf("green") != -1){
				return 0x00FF00;
			}else if(str.indexOf("blue") != -1){
				return 0x0000FF;
			}else if(str.indexOf("cyan") != -1){
				return 0x00FFFF;
			}else if(str.indexOf("magenta") != -1){
				return 0xFF00FF;
			}else if(str.indexOf("yellow") != -1){
				return 0xFF0000;
			}else if(str.indexOf("black") != -1){
				return 0x000000;
			}else if(str.indexOf("white") != -1){
				return 0xFFFFFF;
			}else if(str.indexOf("gray") != -1){
				return 0xAAAAAA;
			}else if(str.indexOf("pink") != -1){
				return 0xEE1289;
			}else if(str.indexOf("orange") != -1){
				return 0xFF6600;
			}else if(str.indexOf("brown") != -1){
				return 0x802A2A;
			}else if(str.indexOf("gold") != -1){
				return 0xCFB53B;
			}
			return -1;
		}
		
		public static function statusToColor(status:String):uint{
			var c:int = stringToColor(status);
			if(c == -1){
				return 0xAAAAAA;
			}
			return c as uint;
		}
		

		
		//********************************************
		// Date Functions
		//********************************************
		
		protected static var MONTHS:Array = ["jan","feb", "mar","apr","may","jun","jul","aug","sep","oct","nov","dec"];
		
		public static function isDate(value:String):Boolean{
			return parseDate(value) > 0;
		}
		
		/**
		 * Attempts to parse an object to a Date object then return then number
		 * of milliseconds since Jan 1, 1970.  First the object is passed to
		 * the native Date class which attempts to parse it.  If that fails,
		 * assume an incomplete date string has been passed in and look for
		 * a month and year.
		 * 
		 * If a year exists (YYYY), use that, otherwise assume the current year.
		 * If a month exsists (MMM), use that, otherwise assume the current month.
		 * And, for now, always assume first day of the month.
		 * 
		 * return number of milliseconds since Jan 1, 1970, or -1 for unknown date
		 * **/
		public static function parseDate(value:Object):Number{
			var temp:Number = Date.parse(value);
			if (temp > 0){
				return temp;
			}
			if (value is String){
				var dateString:String = (value as String).toLowerCase();
				
				//Try some other options...
				var findAnythin:Boolean = false;
				var pattern:RegExp;
				var index:int = -1;
				
				//Year (YYYY)
				var year:Number = new Date().fullYear;
				pattern = /\d\d\d\d/;
				index = dateString.search(pattern);
				if (index > -1){
					year = Number(dateString.slice(index, index+4));
					findAnythin = true;
				}
				
				//Month
				var month:Number = new Date().month;
				for (var i:int=0; i<12; ++i){
					index = dateString.search(MONTHS[i]);
					if (index > -1){
						month = i;
						findAnythin=true;
						break;
					}
				}
				
				//Assume first day of the month
				if (findAnythin){
					var parsedDate:Date = new Date(year, month, 1);
					return parsedDate.time;
				}
			}
			
			
			
			return -1;
		}
		
		public static function getDictionarySize(dict:Dictionary):Number{
			var count:Number = 0;
			for (var item:* in dict){
				count++;
			}
			
			return count;
		}
	}
}