package com.edgeti.EdgeUtils
{
	import com.edgeti.EdgeUtils.logger.Logger;
	
	import flash.events.Event;
	import flash.xml.XMLDocument;
	import flash.xml.XMLNode;
	import flash.xml.XMLNodeType;
	
	import mx.containers.TabNavigator;
	import mx.containers.VBox;
	import mx.controls.RichTextEditor;
	import mx.controls.TextArea;
	import mx.events.FlexEvent;
	
	public class TextSaveStatePanel extends SaveStatePanel
	{
		protected var _editor:RichTextEditor;
		protected var _display:TextArea;
		protected var _htmlStr:String;
		protected var _logger:Logger = Logger.getLogger();
		
		public function TextSaveStatePanel()
		{
			super();
		}
		
		override public function toXml():XML{
			var xmlState:XML = <TextSaveStatePanel />;
			
			xmlState = saveBasics(xmlState);
			
			var hstr:String = htmlEscape(_editor.htmlText);
			var richText:XML = <RichText/>;
			richText.appendChild(hstr);
			
			xmlState.appendChild(richText);

			return xmlState;
		}
		
		/**
		 * Loads the display from the description xml. Because the html component cannot be added
		 * to a panel that doesn't exist yet (it's instanced in createChildren()), if the contained
		 * RichTextEditor is null, then the html is added after the FlexEvent.CREATION_COMPLETE event is thrown
		 **/
		override public function fromXml(state:XML):void{
			super.fromXml(state);
			_htmlStr = state.RichText[0];
			if(_editor != null){
				var str:String = htmlUnescape(_htmlStr);
				_editor.htmlText = str;
				_display.htmlText = str;
			}else{
				addEventListener(FlexEvent.CREATION_COMPLETE, setHtml);
			}
		}
		
		/**
		 * Add the html to the RichTextEditor, if it and the html exist
		 **/
		private function setHtml(evt:FlexEvent):void{
			removeEventListener(FlexEvent.CREATION_COMPLETE, setHtml);
			if(_htmlStr == null){
				_logger.error("TextSaveStatePanel: no html to add to editor");
				return;
			}
			if(_editor == null){
				_logger.error("TextSaveStatePanel: editor is null");
				return;
			}
			var str:String = htmlUnescape(_htmlStr);
			_editor.htmlText = str;
			_display.htmlText = str;
		}
		
		/**
		 * Add the RichTextEditor component to the panel
		 **/
		override protected function createChildren():void{
			super.createChildren();
			
			var tn:TabNavigator = new TabNavigator();
			tn.percentHeight = 100;
			tn.percentWidth = 100;
			addChild(tn);
			
			var vb:VBox = new VBox();
			vb.percentHeight = 100;
			vb.percentWidth = 100;
			vb.label = "Display";
			tn.addChild(vb);
			
			_display = new TextArea();
			_display.percentHeight = 100;
			_display.percentWidth = 100;
			_display.editable = false;
			vb.addChild(_display);
			
			vb = new VBox();
			vb.percentHeight = 100;
			vb.percentWidth = 100;
			vb.label = "Edit";
			tn.addChild(vb);
			
			_editor = new RichTextEditor();
			_editor.percentHeight = 100;
			_editor.percentWidth = 100;
			vb.addChild(_editor);		
			
			_editor.addEventListener(Event.CHANGE, updateDisplay);
		}
		
		private function updateDisplay(evt:Event):void{
			_display.htmlText = _editor.htmlText;
		}
		
		/**
		 * Force an html strin into it's escaped (i.e. '<' becomes '&lt') form
		 **/
		public static function htmlEscape(str:String):String
        {
            return XML(new XMLNode(XMLNodeType.TEXT_NODE, str)).toXMLString();
        }

		/**
		 * Turn an escaped html string into normal form (i.e. '&lt' becomes '<')
		 **/
		public static function htmlUnescape(str:String):String
        {
            var xmld:XMLDocument =  new XMLDocument(str);
            var retstr:String = xmld.firstChild.nodeValue;
            if(retstr == null){
            	retstr = str;
            }
            return retstr;
        }
	
		
	}
}