package com.edgeti.EdgeUtils
{
	import flash.events.MouseEvent;
	
	import mx.events.FlexEvent;

	/**
	 * 
	 * Panel implements two basic methods for saving off the current
	 * state of a widget and for loading it back at a later time:
	 * toXml() and fromXml().
	 * 
	 * **/
	public class SaveStatePanel extends ConfigurablePanel
	{
		protected var _panelXml:XML;
		protected var _enableTBMaximize:Boolean = false;
		
		public function SaveStatePanel()
		{
			super();
			allowSearch = false;
		}
		
		/**
		 * Called upon creationComplete so some properties that were
		 * set may be applied such as creating the window in a minimized
		 * state.
		 * 
		 * **/
		override protected function onCreationComplete(evt:FlexEvent):void{
			super.onCreationComplete(evt);
			if (_enableTBMaximize) {
				titleBar.removeEventListener(MouseEvent.DOUBLE_CLICK, renameHandler);
				titleBar.addEventListener(MouseEvent.DOUBLE_CLICK, TBDoubleClickHandler);
			} else {
				titleBar.removeEventListener(MouseEvent.DOUBLE_CLICK, TBDoubleClickHandler);
				titleBar.addEventListener(MouseEvent.DOUBLE_CLICK, renameHandler);
			}
		}
		
		//************************************
		// Save
		//************************************
		
		/**
		 * Saves the current state of the panel for reloading at a 
		 * later time.  State includes title, position, dimensions
		 * as well as details on data currently displayed (not the
		 * data itself but most likely the query to get it).  It
		 * may also include things as small as column order and 
		 * width on a datagrid for example.
		 * 
		 * This method should be overridden so opening xml tag states
		 * the exact class name:
		 * 
		 * '<SaveStatePanel x="0" y="0" width="100" height="100" title="Default"/>'
		 * 
		 * 
		 * All properties do no necessarily need to be an xml
		 * attribute.  The xml element describing the panel may
		 * contain as many sub-elements as required.
		 * **/
		public function toXml():XML{
			var xmlState:XML = <SaveStatePanel />;
			
			xmlState = saveBasics(xmlState);
			
			return xmlState;
		}
		
		/**
		 * This small helper method saves the basics which should 
		 * apply to all panels:
		 * 
		 * title, x, y, width, height
		 * **/
		protected function saveBasics(state:XML):XML{
			state.@title = title;
			
			if (windowState == WINDOW_STATE_MAXIMIZED ||
				windowState == WINDOW_STATE_MINIMIZED){
					
				state.@x = _oldX;
				state.@y = _oldY;
				state.@width = _oldW;
				state.@height = _oldH;
			} else {
				state.@x = x;
				state.@y = y;
				state.@width = width;
				state.@height = height;
			}
			
			state.@state = windowState;
			
			return state;
		}
		
		//************************************
		// Load
		//************************************
		
		/**
		 * Loads the state of a widget from an xml element produced
		 * by the toXml() method.  
		 * 
		 * This should be able to run both before and after the 
		 * createChildren() method has been executed to prevent
		 * timing issues.
		 * 
		 * **/
		public function fromXml(state:XML):void{
			_panelXml = state;
			title = state.@title;
			
			x = state.@x;
			y = state.@y;
			width = state.@width;
			height = state.@height;
			
			windowState = state.@state;
		}
		
		/**
		 * Loads the state of a widget from an xml element produced
		 * by the toXml() method.  
		 * this method is derived from fromXml() method, but forces WINDOW_STATE
		 * 
		 * **/
		public function forceFromXml(state:XML):void{
			_panelXml = state;
			title = state.@title;
			
			x = state.@x;
			y = state.@y;
			width = state.@width;
			height = state.@height;
			windowState = state.@state;
			if (windowState == WINDOW_STATE_DEFAULT) {
				forceDefaultPanel();
			} else if (windowState == WINDOW_STATE_MAXIMIZED) {
				forceMaximizePanel();
			} else if (windowState == WINDOW_STATE_MINIMIZED) {
				forceMinimizePanel();
			}
		}
		/**
		 * Loads the state of a widget from an xml element produced
		 * by the toXml() method.  
		 * this method is derived from fromXml() method, but forces WINDOW_STATE
		 * 
		 * **/
		public function forceFromXml2(state:XML):void{
			_panelXml = state;
			title = state.@title;
			
			windowState = state.@state;
			if (windowState == WINDOW_STATE_DEFAULT) {
				forceDefaultPanel2();
			} else if (windowState == WINDOW_STATE_MAXIMIZED) {
				forceMaximizePanel2();
			} else if (windowState == WINDOW_STATE_MINIMIZED) {
				forceMinimizePanel2();
			}
		}
		
		/**
		 * enable maximize on doublc click on TitleBar
		 * */
		public function set enableTitleBarMaximize (value:Boolean) : void {
			_enableTBMaximize = value;
		}
		
		/**
		 * event handler for TitleBar click
		 * minimize if current state is MAXIMIZED or DEFAULT, maximize otherwise
		 * **/
		protected function TBDoubleClickHandler(evt:MouseEvent):void{
			if (windowState == WINDOW_STATE_MINIMIZED) {
				forceMaximizePanel();
			} else {
				forceMinimizePanel();
			}
		}
	}
}