package com.edgeti.EdgeUtils.ItemRenderers
{
	import flash.events.MouseEvent;
	
	import mx.controls.RadioButton;
	import mx.controls.treeClasses.TreeItemRenderer;
	import mx.controls.treeClasses.TreeListData;

	public class RadioButtonTreeRenderer extends TreeItemRenderer
	{
		protected var _radiobutton: RadioButton;
		
		public function RadioButtonTreeRenderer()
		{
			super();
		}
		
		
		private function onradioButtonClick( event: MouseEvent ): void
		{
			if( data != null )
			{
				var _listData:TreeListData = listData as TreeListData;
				if(_listData.hasChildren){
					_radiobutton.selected = false;
						 return;
				}
				var item:Object = _listData.item;
				
				if (item && item.hasOwnProperty("selected")){
					item.selected = _radiobutton.selected;
				}
			}
		}
		
		override protected function createChildren( ): void
		{
			super.createChildren( );
			if( !_radiobutton )
			{
				_radiobutton = new RadioButton( );
				_radiobutton.addEventListener( MouseEvent.CLICK, onradioButtonClick );
				addChild( _radiobutton );
			}
		}
		
		override protected function measure():void
		{
			super.measure();
	
			var w:Number = data ? (listData as TreeListData).indent : 0;
	
			if ( disclosureIcon )
				w += disclosureIcon.width;
	
			if ( icon )
				w += icon.measuredWidth;
	
			if ( label.width < 4 || label.height < 4 )
			{
				label.width  = 4;
				label.height = 16;
			}
			
			if ( isNaN( explicitWidth ) )
			{
				w += label.getExplicitOrMeasuredWidth( );
				w += _radiobutton.getExplicitOrMeasuredWidth( );	
				measuredWidth  = w;
				measuredHeight = Math.max( _radiobutton.getExplicitOrMeasuredHeight( ), label.getExplicitOrMeasuredHeight( ) );
			}
			else
			{
				label.width = Math.max(explicitWidth - ( w + _radiobutton.getExplicitOrMeasuredWidth( ) ), 4 );
				measuredHeight = Math.max( _radiobutton.getExplicitOrMeasuredHeight( ), label.getExplicitOrMeasuredHeight( ) );
				
				if ( icon && icon.measuredHeight > measuredHeight )
					measuredHeight = icon.measuredHeight;
			}
		}
		
		override protected function commitProperties( ): void
		{
			super.commitProperties( );
			
			if( data != null )
			{
				var _listData:TreeListData = listData as TreeListData;
				if (_listData.item && _listData.item.hasOwnProperty("selected")){
					_radiobutton.selected = _listData.item.selected;
				}
			}
		}
		
		override protected function updateDisplayList( unscaledWidth: Number, unscaledHeight: Number ): void
		{
			super.updateDisplayList( unscaledWidth, unscaledHeight );
	
			var startx: Number = data ? ( listData as TreeListData ).indent : 0;
			
			if ( disclosureIcon )
			{
				disclosureIcon.x = startx;
				startx = disclosureIcon.x + disclosureIcon.width;
				disclosureIcon.setActualSize( disclosureIcon.width, disclosureIcon.height );
				disclosureIcon.visible = data ? ( listData as TreeListData ).hasChildren : false;
			}
			
			if ( icon )
			{
				icon.x = startx;
				startx = icon.x + icon.measuredWidth;
				icon.setActualSize(icon.measuredWidth, icon.measuredHeight);
			}
			
			if( radioButton )
			{
				_radiobutton.x = startx;
				startx = radioButton.x + radioButton.measuredWidth;
				radioButton.setActualSize( radioButton.measuredWidth, radioButton.measuredHeight );
			}
			
			label.x = startx;
			label.setActualSize( unscaledWidth - startx, measuredHeight );
	
			var verticalAlign:String = getStyle("verticalAlign");
			
			if (verticalAlign == "top")
			{
				label.y = 0;
				_radiobutton.y = 0;
				
				if ( icon )
					icon.y = 0;
				if ( disclosureIcon )
					disclosureIcon.y = 0;
			} else if ( verticalAlign == "bottom")
			{
				label.y = unscaledHeight - label.height + 2; // 2 for gutter
				_radiobutton.y = unscaledHeight - radioButton.height + 2; // 2 for gutter
				if ( icon )
					icon.y = unscaledHeight - icon.height;
				if ( disclosureIcon )
					disclosureIcon.y = unscaledHeight - disclosureIcon.height;
			} else
			{
				label.y    = ( unscaledHeight - label.height ) / 2;
				radioButton.y = ( unscaledHeight - radioButton.height ) / 2;
				if ( icon )
					icon.y = ( unscaledHeight - icon.height ) / 2;
				if ( disclosureIcon )
					disclosureIcon.y = ( unscaledHeight - disclosureIcon.height ) / 2;
			}
		}		
		
		public function get radioButton( ): RadioButton
		{
			return _radiobutton;
		}
	}		
}