package com.edgeti.EdgeUtils.ItemRenderers
{
	import com.edgeti.EdgeUtils.Utils;
	import com.edgeti.EdgeUtils.logger.Logger;
	
	import flash.events.MouseEvent;
	
	import mx.controls.CheckBox;
	import mx.controls.treeClasses.TreeItemRenderer;
	import mx.controls.treeClasses.TreeListData;
	import mx.core.mx_internal;
	
	use namespace mx_internal;
	
	/**
	 * Checkbox item renderer for objects with a 'selected' property in Tree controls.
	 * **/
	public class CheckBoxTreeRenderer extends TreeItemRenderer
	{
		private var _logger:Logger = new Logger();
		protected var _checkbox: CheckBox;
		
		public function CheckBoxTreeRenderer( )
		{
			super( );
		}
		
		
		private function onCheckboxClick( event: MouseEvent ): void
		{
			if( data != null )
			{
				var _listData:TreeListData = listData as TreeListData;
				if (_listData.item){	
					if(_listData.item.hasOwnProperty("selected")){
						 _listData.item.selected = _checkbox.selected;
					}
					else if(_listData.item is XML){
						var xml:XML = _listData.item as XML;
						if(_checkbox.selected){
							Utils.setXmlBranchAttribute(xml, "selected", "true");
						}else{
							Utils.setXmlBranchAttribute(xml, "selected", "false");							
						}
					}
				}
			}
		}
		
		override protected function createChildren( ): void
		{
			super.createChildren( );
			if( !_checkbox )
			{
				_checkbox = new CheckBox( );
				_checkbox.addEventListener( MouseEvent.CLICK, onCheckboxClick );
				addChild( _checkbox );
			}
		}
		
		override protected function measure():void
		{
			super.measure();
	
			var w:Number = data ? (listData as TreeListData).indent : 0;
	
			if ( disclosureIcon )
				w += disclosureIcon.width;
	
			if ( icon )
				w += icon.measuredWidth;
	
			if ( label.width < 4 || label.height < 4 )
			{
				label.width  = 4;
				label.height = 16;
			}
			
			if ( isNaN( explicitWidth ) )
			{
				w += label.getExplicitOrMeasuredWidth( );
				w += _checkbox.getExplicitOrMeasuredWidth( );	
				measuredWidth  = w;
				measuredHeight = Math.max( _checkbox.getExplicitOrMeasuredHeight( ), label.getExplicitOrMeasuredHeight( ) );
			}
			else
			{
				label.width = Math.max(explicitWidth - ( w + _checkbox.getExplicitOrMeasuredWidth( ) ), 4 );
				measuredHeight = Math.max( _checkbox.getExplicitOrMeasuredHeight( ), label.getExplicitOrMeasuredHeight( ) );
				
				if ( icon && icon.measuredHeight > measuredHeight )
					measuredHeight = icon.measuredHeight;
			}
		}
		
		override protected function commitProperties( ): void
		{
			super.commitProperties( );
			
			if( data != null )
			{
				var _listData:TreeListData = listData as TreeListData;

				if (_listData.item){	
					if(_listData.item.hasOwnProperty("selected")){
						 _checkbox.selected = _listData.item.selected;
					}
					else if(_listData.item is XML){
						var xml:XML = _listData.item as XML;
						if(xml.@selected == "true"){
							_checkbox.selected = true;
						}else if (xml.@selected == "false"){
							_checkbox.selected = false;
						}						
					}
				}
			}
		}
		
		override protected function updateDisplayList( unscaledWidth: Number, unscaledHeight: Number ): void
		{
			super.updateDisplayList( unscaledWidth, unscaledHeight );
	
			var startx: Number = data ? ( listData as TreeListData ).indent : 0;
			
			if ( disclosureIcon )
			{
				disclosureIcon.x = startx;
				startx = disclosureIcon.x + disclosureIcon.width;
				disclosureIcon.setActualSize( disclosureIcon.width, disclosureIcon.height );
				disclosureIcon.visible = data ? ( listData as TreeListData ).hasChildren : false;
			}
			
			if ( icon )
			{
				icon.x = startx;
				startx = icon.x + icon.measuredWidth;
				icon.setActualSize(icon.measuredWidth, icon.measuredHeight);
			}
			
			if( checkBox )
			{
				_checkbox.x = startx;
				startx = checkBox.x + checkBox.measuredWidth;
				checkBox.setActualSize( checkBox.measuredWidth, checkBox.measuredHeight );
			}
			
			label.x = startx;
			label.setActualSize( unscaledWidth - startx, measuredHeight );
	
			var verticalAlign:String = getStyle("verticalAlign");
			
			if (verticalAlign == "top")
			{
				label.y = 0;
				_checkbox.y = 0;
				
				if ( icon )
					icon.y = 0;
				if ( disclosureIcon )
					disclosureIcon.y = 0;
			} else if ( verticalAlign == "bottom")
			{
				label.y = unscaledHeight - label.height + 2; // 2 for gutter
				_checkbox.y = unscaledHeight - checkBox.height + 2; // 2 for gutter
				if ( icon )
					icon.y = unscaledHeight - icon.height;
				if ( disclosureIcon )
					disclosureIcon.y = unscaledHeight - disclosureIcon.height;
			} else
			{
				label.y    = ( unscaledHeight - label.height ) / 2;
				checkBox.y = ( unscaledHeight - checkBox.height ) / 2;
				if ( icon )
					icon.y = ( unscaledHeight - icon.height ) / 2;
				if ( disclosureIcon )
					disclosureIcon.y = ( unscaledHeight - disclosureIcon.height ) / 2;
			}
		}		
		
		public function get checkBox( ): CheckBox
		{
			return _checkbox;
		}
	}
}