package com.edgeti.EdgeUtils
{
	import com.edgeti.EdgeUtils.logger.Logger;
	
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.events.Event;
	import flash.events.HTTPStatusEvent;
	import flash.events.IOErrorEvent;
	import flash.events.ProgressEvent;
	import flash.geom.Matrix;
	import flash.net.URLRequest;
	
	import mx.containers.Canvas;
	import mx.core.UIComponent;

	public class ImageCanvas extends Canvas
	{
		private var _shape:Shape;
		private var _uic:UIComponent;
		private var _bmp:Bitmap;
		private var _matrix:Matrix;
		private var _loader:Loader;
		private var _logger:Logger = Logger.getLogger();
			
		public function ImageCanvas()
		{
			super();
			_matrix = new Matrix();
			_loader = new Loader();

			_loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, faultHandler);
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, handleConfigLoadComplete);
			_loader.contentLoaderInfo.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpStatusHandler);
            _loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
            _loader.contentLoaderInfo.addEventListener(Event.OPEN, openHandler);
            _loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, progressHandler);
		}
		
		public function set bitmap(bmp:Bitmap):void{
			_bmp = bmp;
			invalidateDisplayList();
		}
		
		override protected function createChildren():void{
			super.createChildren();
			_uic = new UIComponent();
			_uic.percentHeight = 100;
			_uic.percentWidth = 100;
			_shape = new Shape();
			_uic.addChild(_shape);
			addChild(_uic);
			setChildIndex(_uic, 0);
		}
		
		override public function invalidateDisplayList():void{
			super.invalidateDisplayList();
			if(_bmp != null){
				var xScale:Number = width / _bmp.width;
				var yScale:Number = height / _bmp.height;
				_matrix.identity();
				//_matrix.translate(-_imageBitmap.width * 0.5, -_imageBitmap.height * 0.5);
				_matrix.scale(xScale, yScale);
				//_matrix.translate(x, y)
				
				_shape.graphics.beginBitmapFill(_bmp.bitmapData, _matrix, false);
				_shape.graphics.drawRect(0, 0, width, height);
				_shape.graphics.endFill();
			}
		}
		
		public function set imageUrl(url:String):void{	
			if(url == null){
				_shape.graphics.clear();
				return;
			}	
			_logger.info("requesting background image from: "+	url);
			_loader.load(new URLRequest(url));
		}
		
		private function faultHandler(evt:IOErrorEvent):void{
			_logger.error("problem loading background image from: "+_loader.contentLoaderInfo.loaderURL+". Bytes loaded = "+_loader.contentLoaderInfo.bytesLoaded+
				"Bytes total = "+_loader.contentLoaderInfo.bytesTotal+". error message = "+evt.toString());
			_loader.contentLoaderInfo.loaderURL
		}
		
		private function handleConfigLoadComplete(evt:Event):void{
			_logger.info("background image loaded");
			_bmp = evt.currentTarget.content;
			invalidateDisplayList();
		}
		
		  private function httpStatusHandler(event:HTTPStatusEvent):void {
            _logger.info("httpStatusHandler: " + event);
        }

        private function initHandler(event:Event):void {
            _logger.info("initHandler: " + event);
        }

        private function openHandler(event:Event):void {
            _logger.info("openHandler: " + event);
        }

        private function progressHandler(event:ProgressEvent):void {
            //_logger.info("progressHandler: bytesLoaded=" + event.bytesLoaded + " bytesTotal=" + event.bytesTotal);
        }


	}
}