package com.edgeti.EdgeUtils.IconManager
{
	import com.edgeti.EdgeUtils.logger.Logger;
	
	import flash.events.*;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.http.HTTPService;
	import mx.utils.ArrayUtil;

	public class IconService extends EventDispatcher
	{
		private var service:HTTPService;
		private var _url:String;

		protected var logger:Logger = Logger.getLogger();

        [Bindable]
        public var gallery:Gallery;

        public function IconService(url:String)
        {
        	_url = url;
            service = new HTTPService();
            //The following prevent caching
            service.url = _url + "?" + new Date().getMilliseconds();
            service.addEventListener(ResultEvent.RESULT, resultHandler);
            service.addEventListener(FaultEvent.FAULT, faultHandler);
            service.send();
        }

        private function resultHandler(event:ResultEvent):void
        {
            var result:ArrayCollection = event.result.icons.icon is ArrayCollection
                ? event.result.icons.icon as ArrayCollection
                : new ArrayCollection(ArrayUtil.toArray(event.result.icons.icon));
                
            gallery = new Gallery(result);
        }
        
        private function faultHandler(event:FaultEvent):void
        {
        	logger.error("Error in IconSerivce: " + event.message);
        }
        
        public function refresh():void{
        	service.url = _url + "?" + new Date().getMilliseconds();
            service.send();
        }

	}
}