package com.edgeti.EdgeUtils
{
	import com.as3xls.xls.ExcelFile;
	import com.as3xls.xls.Sheet;
	
	import flash.net.FileReference;
	import flash.utils.ByteArray;
	
	import mx.collections.ArrayCollection;

	public class ExportUtils
	{
		/**
		 * export arrayCollection to excel spreadsheet to client
		 * */
		public static function exportToExcel (arrCol:ArrayCollection, filename:String=null, header:Boolean=true) : void {
			var sheet:Sheet = new Sheet;
			var dataPro:ArrayCollection = arrCol;
			var rowCount:int = dataPro.length;
			var columnHeaders:Array = new Array;
			
			var o:Object  = (arrCol.getItemAt(0) as Object);
			var record:Object;
			var c:int;
			var r:int;
			var i:int;
			var s:String;
			
			// write header and data for 
			if (header) {
				// get count of properties as columnCount
				for (s in o) {
					if (s != "mx_internal_uid") {
						columnHeaders.push(s);
					}
				}
				// allocate columns first!
				sheet.resize(rowCount+1, columnHeaders.length);
				
				// write out headers
				for (i = 0; i < columnHeaders.length; i++) {
					sheet.setCell(0, i, columnHeaders[i]);
				}
				
				// write out data
				for (r = 0; r < rowCount; r++){
					record = dataPro.getItemAt(r);
					for (c = 0; c < columnHeaders.length; c++) {
						if (record.hasOwnProperty(columnHeaders[c])) {
							sheet.setCell (r + 1, c, record[columnHeaders[c]]);
						}
					}
				}
			} else {
				// write everything in arrCol
				// find max column length
				var maxCol:int = 0;
				for each (o in arrCol) {
					var cnt:int = 0;
					for (s in o) {
						cnt++;
					} 
					if (cnt > maxCol) {
						maxCol = cnt;
					}
				}
				sheet.resize(rowCount+1, maxCol);
				// write out data
				for (r = 0; r < rowCount; r++){
					record = dataPro.getItemAt(r);
					c = 0;
					for (s in record) {
						sheet.setCell(r, c++, record[s]);
					}
				}
			}
			
			var xls:ExcelFile = new ExcelFile();  
			xls.sheets.addItem(sheet);  
			
			var bytes: ByteArray = xls.saveToByteArray();  
			var fr:FileReference = new FileReference();  
			fr.save(bytes, (filename == null ? "Sample.xls" : filename + ".xls"));
		}
		public function ExportUtils()
		{
		}
	}
}