package com.edgeti.EdgeUtils
{
	import com.edgeti.EdgeUtils.DynamicPanel.DynamicPanel;
	import com.edgeti.EdgeUtils.DynamicPanel.skins.candy.configButton;
	
	import flash.events.MouseEvent;
	
	import mx.containers.Canvas;
	import mx.controls.Button;

	/**
	 * Adds a configure button and screen to a DynamicPanel.
	 * Subclasses may override the contents of the configuration
	 * screen to fit their needs.
	 * **/
	public class ConfigurablePanel extends DynamicPanel
	{
		protected var _allowConfigure:Boolean = false;
		
		protected var _configureButton:Button;
		
		protected var _configScreen:Canvas;
		
		public function ConfigurablePanel()
		{
			super();
		}
		
		//********************************************
		// Overrides
		//********************************************
		
		/**
		 * Adds the configure button upon creation complete.
		 * **/
		override protected function createChildren():void{
			super.createChildren();
			
			if (_allowConfigure){
				_configureButton = new Button();
				initButton(_configureButton, "Configure", configButton);
				_configureButton.addEventListener(MouseEvent.CLICK, configHandler);
				
				_buttonContainer.width += 20;
				_buttonContainer.addChildAt(_configureButton, 0);
			}
		}
		
		/**
		 * When minimized, the extra buttons are hidden from view.
		 * **/
		override protected function commitProperties():void{
			
			if (_windowStateDirty && _creationComplete){
				//Minimize
				if (windowState == WINDOW_STATE_MINIMIZED){
					
					if (_configureButton){
						_configureButton.visible = false;
					}
					
				//Restore
				} else {
					if (_configureButton){
						_configureButton.visible = true;
					}
				}
			}
			
			super.commitProperties();
		}
		
		//********************************************
		// Config Methods
		//********************************************
		
		/**
		 * Handles clicks of the config button.  If config screen doesn't exist yet,
		 * it is created by calling createConfigScreen() and displayed.  If it has been
		 * created but is not visible, it is set to visible and moved to the top of the 
		 * z-order.  If it is currently visible, it is hidden and onConfigClose() is called.
		 * 
		 * Canvas width and height are both set to 100% and its background set to white after
		 * createConfigScreen() is called to ensure the widget itself is covered.
		 * **/
		private function configHandler(evt:MouseEvent):void{
			if (_configScreen && _configScreen.visible){
				_configScreen.visible = false;
				removeChild(_configScreen);
				onConfigClose();
			} else if (_configScreen){
				_configScreen.visible = true;
				addChild(_configScreen);
			} else {
				_configScreen = createConfigScreen();
				_configScreen.percentHeight = 100;
				_configScreen.percentWidth = 100;
				_configScreen.setStyle("backgroundAlpha", 1);
				_configScreen.setStyle("backgroundColor", 0xFFFFFF);
				addChild(_configScreen);
			}
		}
		
		/**
		 * Responsible for creating the configuration menu.  This should be overriden to
		 * create a custom menu for your widget.
		 * **/
		protected function createConfigScreen():Canvas{
			return new Canvas();
		}
		
		/**
		 * Called when the configuration menu is closed by repeatedly clicking the config
		 * button.  This should be overriden to call or contain your configuration change 
		 * handling code.
		 * **/
		protected function onConfigClose():void{
			
		}
	}
}