package com.edgeti.EdgeUtils
{
	import com.edgeti.EdgeUtils.general.SingletonDataDictionary;
	import com.edgeti.EdgeUtils.logger.Logger;
	
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLLoaderDataFormat;
	import flash.net.URLRequest;

	public class ConfigLoader extends EventDispatcher
	{
		protected var logger:Logger=Logger.getLogger();
		
		public static const LOAD_COMPLETE:String = "loadComplete";
		public static const LOAD_FAILED:String = "loadFailed";

		protected var fileUrl:String=null;

		public function ConfigLoader(fileUrl:String=null)
		{
			this.fileUrl=fileUrl;
			logger.info("ConfigureLoader() fileUrl = "+fileUrl);
		}

		//*********************************************
		// Self load and configure
		//*********************************************

		/**
		 * Attempts to load the 'properties' file assets/setupModel.xml.
		 *
		 * @param callback a function to be called once loading of the properties is complete
		 *
		 */
		public function configure():void
		{
			var loader:URLLoader=new URLLoader();
			loader.dataFormat=URLLoaderDataFormat.TEXT;
			loader.addEventListener(IOErrorEvent.IO_ERROR, faultHandler);
			loader.addEventListener(Event.COMPLETE, handleConfigLoadComplete);

			var urlRequest:URLRequest=new URLRequest("assets/setupModel.xml");

			if (fileUrl != null)
				urlRequest=new URLRequest(fileUrl);

			loader.load(urlRequest);
		}

		/**
		 * Reads the setupModel.xml file once it has been successfully loaded.
		 *
		 * @param evt Event.COMPLETE
		 *
		 */
		protected function handleConfigLoadComplete(evt:Event):void
		{
			var configXML:XML=new XML(evt.target.data);
			var elements:XMLList=configXML.children();
			var element:XML;
			var key:String;
			var names:String;
			var val:String;
			for each (element in elements)
			{
				//trace (element.toXMLString());
				key=element.localName();
				names = element.namespace().toString();
				val=element.text().toString();
				if (names.length > 0)
					SingletonDataDictionary.addItem(key, val, names);
				else
					SingletonDataDictionary.addItem(key, val);
			}
			
			dispatchEvent(new Event(LOAD_COMPLETE));
		}

		/**
		 * Called if an error occurs while trying to load setupModel.xml.
		 *
		 * @param evt IOErrorEvent.IO_ERROR
		 *
		 */
		protected function faultHandler(evt:IOErrorEvent):void
		{
			logger.error(evt.text);
			dispatchEvent(new Event(LOAD_FAILED));
		}
	}
}
