package com.edgeti.RemoteClasses
{
	import mx.collections.ArrayCollection;
	
	[RemoteClass(alias="com.edgeti.VisibilityServer.WhereClause")]
	public class WhereClause
	{
		public static const EQUALS:String = "=";
		public static const NOT_EQUALS:String = "!=";
		
		[Bindable]
		public static var OPERATORS:ArrayCollection = new ArrayCollection([EQUALS, NOT_EQUALS]);
		
		public var columnName:String;
		public var operator:String;
		public var value:String;

		public function toXml():XML{
			var whereState:XML = <where />;
			whereState.@columnName = columnName;
			whereState.@operator = operator;
			whereState.@value = value;
			
			return whereState;
		}
		
		public function fromXml(state:XML):void{
			columnName = state.@columnName;
			operator = state.@operator;
			value = state.@value;
		}
		
		public function toString():String{
			return "WHERE " + columnName + " " + operator + " " + value;
		}
	}
}