package com.edgeti.RemoteClasses
{
	/**
	 * An object describing a geographical location.  This class is based on
	 * the Google Maps API GClientGeocoder object so if the geocoding service
	 * is available, it should be straight port from JSON objects to Actionscript
	 * or Java objects.
	 * **/
	[Bindable]
	[RemoteClass(alias="com.edgeti.VisibilityServer.LocationInfoObject")]
	public class LocationInfoObject
	{
		//Address accuracy enumerations
		public static const UNKNOWN_ACC:Number 		= 0;
		public static const COUNTRY_ACC:Number 		= 1;
		public static const REGION_ACC:Number 		= 2;
		public static const SUBREGION_ACC:Number 	= 3;
		public static const TOWN_ACC:Number			= 4;
		public static const POSTCODE_ACC:Number 	= 5;
		public static const STREET_ACC:Number 		= 6;
		public static const INTERSECTION_ACC:Number	= 7;
		public static const ADDRESS_ACC:Number 		= 8;
		public static const PREMISE_ACC:Number 		= 9;
		
		public function LocationInfoObject()
		{
		}
		
		/**
		 * A nicely formatted and properly capitalized version of the address.
		 * Example used through this class: 
		 * "Google Headquarters, 1600 Amphitheatre Pkwy, Mountain View, CA 94043, USA".
		 * **/
		public var address:String;
		
		//********************************************
		// Address Details
		//********************************************
		/**
		 * An attribute indicating how accurately we were able to geocode the given address
		 * (ex. 9).
		 * **/
		public var accuracy:Number;
		
		/**
		 * Country containing the address (ex. "US").
		 * **/
		public var countryCode:String;
		
		/**
		 * Region containg the address (ex. "CA").
		 * **/
		public var administrativeArea:String;
		
		/**
		 * Subregion containing the address (ex. "Santa Clara" - the county).
		 * **/
		public var subAdministrativeArea:String;
		
		/**
		 * Town, city, village, etc. (ex. "Mountain View").
		 * **/
		 public var locality:String;
		 
		 /**
		 * Street address (ex. "1600 Amphitheatre Pkwy").
		 * **/
		 public var thoroughfare:String;
		 
		 /**
		 * Building name (ex. "Google Headquarters").
		 * **/
		 public var premise:String;
		 
		 /**
		 * Postal code (ex. "94043").
		 * **/
		 public var postalCode:String;
		
		//********************************************
		// Spacial coordinates
		//********************************************
		/**
		 * Latitude of the location.
		 * **/
		 public var latitude:Number;
		 
		 /**
		 * Longitude of the location.
		 * **/
		 public var longitude:Number;
		 
		 /**
		 * Altitude of the locarion.
		 * **/
		 public var altitude:Number;

	}
}