package com.edgeti.RemoteClasses
{
	import com.edgeti.EdgeUtils.logger.Logger;
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	[RemoteClass (alias = "com.edgeti.VisibilityServer.FlexTreeObject")]
	public class FlexTreeObject
	{
		public var label:String;
		public var children:ArrayCollection;
		public var data:Object;
		public var parent:FlexTreeObject;
		public var selected:Boolean;
		
		private var logger:Logger = new Logger();
		
		public function FlexTreeObject(name:String = null)
		{
			parent = null;
			label = name;
			//children = new ArrayCollection();
		}

		public function addChild(child:FlexTreeObject):void{
			if(children == null){
				children = new ArrayCollection();
			}
			child.parent = this;
			children.addItem(child);
		}
		
		public function addUniqueChild(child:FlexTreeObject):void{
			if(children == null){
				children = new ArrayCollection();;
			}	
			var fto:FlexTreeObject;
			for each (fto in children){
				if(child.label == fto.label){
					return;
				}
			}
			//logger.debug(label+" added child: "+child.label);
			child.parent = this;
			children.addItem(child);		
		}
		
		public function removeBranch(child:FlexTreeObject):void{
			if(children == null){
				return;
			}
			var index:int = children.getItemIndex(child);
			if(index != -1){
				children.removeItemAt(index);
				child.clear();
			}
		}
		
		public function removeChild(child:FlexTreeObject):void{
			if(children == null){
				return;
			}
			var index:int = children.getItemIndex(child);
			if(index != -1){
				children.removeItemAt(index);
			}
		}
		
		public function removeAllChildren():void{
			if(children == null){
				return;
			}			
			var fto:FlexTreeObject;
			var i:int;
			for(i = 0; i < children.length; ++i){
				fto = children.getItemAt(i) as FlexTreeObject;
				fto.removeAllChildren();
				fto.clear();
				fto = null;
			}
		}
		
		public function clear():void{
			label = "";
			data = null;
			parent = null;
			if(children != null){
				children.removeAll();
			}
		}
		
		public function selectChildren(select:Boolean):void{
			var child:FlexTreeObject;
			if(children != null){ 
				for each(child in children){
					child.selected = select;
					child.selectChildren(select);
				}
			}			
		}
		
		public function selectLeafNodes(select:Boolean):void{
			var child:FlexTreeObject;
			if(children == null){ // we're a leaf node
					selected = select;
			}else{ // keep on going
				for each(child in children){
					child.selectLeafNodes(select);
				}
			}
		}
		
		public function findChildByLabel(str:String):FlexTreeObject{
			if(label.indexOf(str) != -1){
				return this;
			}
			if(children == null){
				return null;
			}
			if(children.length == 0){
				return null;
			}
			var i:int;
			var child:FlexTreeObject;
			var match:FlexTreeObject;
			for(i = 0; i < children.length; ++i){
				child = children.getItemAt(i) as FlexTreeObject;
				match = child.findChildByLabel(str);
				if(match != null){
					return match;
				}
			}
			return null;
		}
		
		public function findChildByPropertyValue(propName:String, propValue:Object):FlexTreeObject{
			var name:String;
			if(data.hasOwnProperty(propName)){
				if(data[propName] == propValue){
					return this;
				} 
			}

			if(children == null){
				return null;
			}
			if(children.length == 0){
				return null;
			}
			
			var i:int;
			var child:FlexTreeObject;
			var match:FlexTreeObject;
			for(i = 0; i < children.length; ++i){
				child = children.getItemAt(i) as FlexTreeObject;
				match = child.findChildByPropertyValue(propName, propValue);
				if(match != null){
					return match;
				}
			}
			return null;
		}
		
		/**
		 * Add this and its children to an arrayCollection. THis will result in a branch that includs this
		 * node and all other nodes below it
		 **/
		public function addToCollection(ac:ArrayCollection):void{
			ac.addItem(this);
			var child:FlexTreeObject;
			if(children != null){
				for each(child in children){
					child.addToCollection(ac);
				}
			}
		}
		
		/**
		 * Add this and its children to an arrayCollection. THis will result in a branch that includs this
		 * node and all other nodes below it
		 **/
		public function addLeafNodesToCollection(ac:ArrayCollection):void{	
			var child:FlexTreeObject;
			
			if(children == null){
				ac.addItem(this);
			}else{
				for each(child in children){
					child.addLeafNodesToCollection(ac);
				}
			}
		}
		
		/**
		 * Get the path and label of this node
		 **/
		public function get fullName():String{
			if(parent == null){
				return label;
			}
			return parent.fullName+"->"+label;
		}
		
		/**
		 * Set the selected value of the parent and it's parent (etc) all the way to the root
		 **/
		public function setParentSelected(sel:Boolean):void{
			selected = sel;
			if(parent != null){
				parent.setParentSelected(sel);
			}
		}
	}
}