package com.edgeti.RemoteClasses
{
	import mx.collections.ArrayCollection;
	
	[Bindable]
	[RemoteClass(alias="com.edgeti.VisibilityServer.ColumnInfoObject")]
	public class ColumnInfoObject
	{
		public static const STRING:String = "STRING";
		public static const NUMBER:String = "NUMBER";
		
		public var name:String;
		public var type:String;
		public var selected:Boolean = false;
		
		[Transient]
		public var width:Number;
		
		public var whereClauses:ArrayCollection;

		public function addClause(clause:WhereClause):void{
			if (whereClauses == null){
				whereClauses = new ArrayCollection();
			}
			
			whereClauses.addItem(clause);
		}
		
		public function get label():String{
			return name;
		}

		public function toXml():XML{
			var columnState:XML = <column />;
			columnState.@name = name;
			columnState.@type = type;
			columnState.@selected = selected;
			columnState.@width = width;
			
			var whereStates:XML = <WhereClauses />;
			for each (var clause:WhereClause in whereClauses){
				whereStates.appendChild(clause.toXml());
			}
			columnState.appendChild(whereStates);
			
			return columnState;
		}
		
		public function fromXml(state:XML):void{
			name = state.@name;
			type = state.@type;
			var temp:String = state.@selected;
			selected = temp == "true" ? true : false;
			temp = state.@width;
			width = Number(temp);
			
			whereClauses = new ArrayCollection();
			for each (var whereState:XML in state.WhereClauses.where){
				var whereClause:WhereClause = new WhereClause();
				whereClause.fromXml(whereState);
				whereClauses.addItem(whereClause);
			}
		}

	}
}