package com.edgeti.EdgeUtils.logger
{
	import flash.sampler.Sample;
	import flash.sampler.getSamples;
	import flash.sampler.startSampling;
	
	/**
	 * Represents a single log entry created either on the Flex
	 * side (com.edgeti.EdgeUtils.logger.Logger) or the java
	 * side using log4j (com.edgeti.Utils.logging.VisibilityLogger).
	 * 
	 * 
	 * **/
	[RemoteClass(alias="com.edgeti.Utils.logging.LoggingEntry")]
	public class LoggingEntry
	{
		//********************************************
		// Levels
		//********************************************
		
		//Taken from log4j
		public static const ALL:int = int.MIN_VALUE;
		public static const DEBUG:int = 10000;
		public static const INFO:int = 20000;
		public static const WARN:int = 30000;
		public static const ERROR:int = 40000;
		public static const FATAL:int = 50000;
		
		//********************************************
		// Properties
		//********************************************
		
		/**
		 * Level of concern assigned to this entry.
		 * **/
		public var level:int;
		/**
		 * Milliseconds since epoch when this entry was created.
		 * **/
		public var timestamp:Number;
		/**
		 * Message string provided during creation.
		 * **/
		public var message:String;
		
		/**
		 * Thread this process was running under (Java only).
		 * **/
		public var threadName:String;
		/**
		 * Stack trace if one was provided.
		 * **/
		public var throwableString:Array;
		
		//Location
		/**
		 * Optional.
		 * **/
		public var className:String;
		/**
		 * Optional.
		 * **/
		public var fileName:String;
		/**
		 * Optional.
		 * **/
		public var lineNumber:String;
		/**
		 * Optional.
		 * **/
		public var methodName:String;
	
		public function LoggingEntry()
		{
		}
		
		/**
		 * Converts the integer value of this entry's level
		 * to the string equivalent.  If the current level
		 * does not match any known levels, the integer
		 * is returned as a string.
		 * **/
		public function getLevelString():String{
			switch (level){
        		case DEBUG:
        			return "DEBUG";
        		case INFO:
        			return "INFO";
        		case WARN:
        			return "WARN";
        		case ERROR:
        			return "ERROR";
        		case FATAL:
        			return "FATAL";
        		default:
        			return level.toString();
        	}
		}
		
		/**
		 * Returns the rendered message string.
		 * 
		 * Current format equivalent to log4j format:
		 *    [%p] %d %l %n\t%m%n
		 * **/
		public function toString():String{
			var retString:String = "["+getLevelString()+"] " +
									new Date(timestamp).toLocaleString() + " ";
			if (className){
				retString += className+"."+methodName+":"+lineNumber; 
			}
			
			retString += "\n\t" + message;
			
			if (throwableString){
				for each (var line:String in throwableString){
					retString += "\n\t\t" + line;
				}
			}
			
			return retString;
		}
		
	}
}