package com.edgeti.EdgeUtils.layout.managers
{
	import com.edgeti.EdgeUtils.DynamicPanel.DynamicPanel;
	import com.edgeti.EdgeUtils.DynamicPanel.PanelEvent;
	
	import mx.containers.Canvas;
	import mx.controls.scrollClasses.ScrollBar;
	import mx.core.UIComponent;
	import mx.effects.AnimateProperty;
	import mx.effects.Move;
	import mx.effects.Parallel;
	import mx.effects.Resize;
	import mx.events.EffectEvent;
	import mx.events.ResizeEvent;

	public class VerticalScrollLayoutManager extends LayoutManagerBase
	{
		protected static const DEFAULT_HEIGHT:int = 400;
		protected static const BUFFER:int = 5;
		protected var _leftOffset:Number = 0;
		
		//Should reflect the height of the canvas
		protected var maxHeight:int = 800;
		
		//Indicates whether or not the canvas should be
		//scrolled to the specific panel on effect end
		// -1 == false
		private var _scrollToIndex:int = -1;
		
		public function VerticalScrollLayoutManager(view:Canvas)
		{
			super(view);
			
			name = "Vertical Scroll";
		}
		
		//************************************
		// Apply / Reset Layout
		//************************************
		
		override public function applyLayout(animate:Boolean):void{
			applyLayoutHelper(animate, 0);
		}
		
		protected function applyLayoutHelper(animate:Boolean, index:int):void{
			if (!_items || _items.length < 1){
				return;
			}
			
			var i:int;
			var wTo:Number = getViewWidth() - 2 * BUFFER;
			var hTo:Number;
			var xTo:Number = BUFFER + _leftOffset;
			var yTo:Number;
			var panel:DynamicPanel;
			
			var animations:Array = new Array();
			//This saves a lot of duplicate code
			var duration:Number = animate ? 1000 : 0;
			
			for (i = index; i<_items.length; ++i){
				panel = _items.getItemAt(i) as DynamicPanel;
				yTo =	getIndexHeight(i);
				
				switch (panel.windowState){
					case DynamicPanel.WINDOW_STATE_DEFAULT:
						hTo = DEFAULT_HEIGHT;
						break;
					case DynamicPanel.WINDOW_STATE_MAXIMIZED:
						hTo = maxHeight;
						break;
					case DynamicPanel.WINDOW_STATE_MINIMIZED:
						hTo = DynamicPanel.MIN_HEIGHT;
						break;
				}
				
				var move:Move = createMoveEffectInstance(panel, xTo, yTo);
				if (move){
					animations.push(move);
				}
				var resize:Resize = createResizeEffectInstance(panel, wTo, hTo);
				if (resize){
					animations.push(resize);
				}
			}
			
			// Only animate if there are items to animate.
			if (animations.length > 0)
			{
				_parallel = new Parallel();
				_parallel.children = animations;
				_parallel.duration = duration;
				_parallel.play();
				_parallel.addEventListener(EffectEvent.EFFECT_END, onEffectEnd);
			}
		}
		
		override protected function getViewWidth():Number{
			//Almost guaranteed to have scroll bars in this layout,
			//so always include them in the layout
			var containerWidth:Number = _view.width - ScrollBar.THICKNESS;
			
			containerWidth = containerWidth / _view.scaleX;
			
			return containerWidth;
		}
		
		protected function getIndexHeight(index:int):Number{
			var h:Number = BUFFER;
			for (var i:int = 0; i < index; ++i){
				var panel:DynamicPanel = _items.getItemAt(i) as DynamicPanel;
				h += BUFFER;
				switch (panel.windowState){
					case DynamicPanel.WINDOW_STATE_DEFAULT:
						h += DEFAULT_HEIGHT;
						break;
					case DynamicPanel.WINDOW_STATE_MAXIMIZED:
						h += maxHeight;
						break;
					case DynamicPanel.WINDOW_STATE_MINIMIZED:
						h += DynamicPanel.MIN_HEIGHT;
						break;
				}
			}
			
			return h;
		}
		
		override protected function onEffectEnd(e:EffectEvent):void{
			super.onEffectEnd(e);
			
			if (_scrollToIndex != -1){
				scrollToIndex(_scrollToIndex);
				_scrollToIndex = -1;
			}
		}
		
		protected function scrollToIndex(index:int):void{
			if (_items.length - 1 < index){
				return;
			} 
			
			var panel:DynamicPanel = _items.getItemAt(index) as DynamicPanel;
			var contentYto:Number = panel.y;
			
			var tweener:AnimateProperty = new AnimateProperty(_view);
			tweener.property = "verticalScrollPosition";
			tweener.fromValue = _view.verticalScrollPosition;
			tweener.toValue = Math.min(contentYto, _view.maxVerticalScrollPosition);
			tweener.duration = 500;
			tweener.play();
		}
		
		//************************************
		// Managed Items Changes
		//************************************
		
		override protected function addPanelListeners(panel:DynamicPanel):void{
			super.addPanelListeners(panel);
			
			panel.allowClose = true;
			panel.allowResize = false;
			panel.allowMinimize = true;
			panel.allowMaximize = true;
			panel.allowMove = false;
		}
		
		override protected function onItemAdd(items:Array, location:int):void{
			super.onItemAdd(items, location);
			
			//Assuming only one panel will be added at a time
			var panel:DynamicPanel = items[0] as DynamicPanel;
			var index:int = _items.getItemIndex(panel);
			applyLayoutHelper(true, index);
			
			_scrollToIndex = index;
		}
		
		override protected function onItemRemove(items:Array, location:int):void{
			super.onItemRemove(items, location);
			
			applyLayoutHelper(true, 0);
		}
		
		override protected function onItemReset():void{
			super.onItemReset();
			applyLayout(false);
		}
		
		//************************************
		// Minimize / Maximize
		//************************************
		
		override protected function onPanelMinimize(evt:PanelEvent):void{
			var panel:DynamicPanel = evt.target as DynamicPanel;
			var index:int = _items.getItemIndex(panel);
			applyLayoutHelper(true, index);
		}
		
		override protected function onPanelMaximize(evt:PanelEvent):void{
			var panel:DynamicPanel = evt.target as DynamicPanel;
			var index:int = _items.getItemIndex(panel);
			applyLayoutHelper(true, index);
		}
		
		override protected function onPanelRestore(evt:PanelEvent):void{
			var panel:DynamicPanel = evt.target as DynamicPanel;
			var index:int = _items.getItemIndex(panel);
			applyLayoutHelper(true, index);
		}
		
		//************************************
		// Container Resize
		//************************************
		
		override protected function onContainerResize(evt:ResizeEvent):void{
			var wTo:Number = getViewWidth() - 2 * BUFFER;
			//Width Changes
			if (evt.oldWidth != _view.width){
				for each (var panel:DynamicPanel in _items){
					panel.width = wTo;
				}
			}
			//Hieght Changes
			if (evt.oldHeight != _view.height){
				maxHeight = getViewHeight() - 2* BUFFER;
				if (_items){
					applyLayout(false);
				}
			}
		}
		
		//************************************
		// Focus Item
		//************************************
		
		override public function focusPanel(panel:UIComponent):void{
			if (panel is DynamicPanel){
				var index:int = _items.getItemIndex(panel);
				scrollToIndex(index);
			}
		}
	}
}