package com.edgeti.EdgeUtils
{
	import com.edgeti.EdgeUtils.DynamicPanel.DynamicPanel;

	/**
	 * 
	 * Panel implements two basic methods for saving off the current
	 * state of a widget and for loading it back at a later time:
	 * toXml() and fromXml().
	 * 
	 * **/
	public class SaveStatePanel extends DynamicPanel
	{
		public function SaveStatePanel()
		{
			super();
			allowSearch = false;
		}
		
		//************************************
		// Save
		//************************************
		
		/**
		 * Saves the current state of the panel for reloading at a 
		 * later time.  State includes title, position, dimensions
		 * as well as details on data currently displayed (not the
		 * data itself but most likely the query to get it).  It
		 * may also include things as small as column order and 
		 * width on a datagrid for example.
		 * 
		 * This method should be overridden so opening xml tag states
		 * the exact class name:
		 * 
		 * '<SaveStatePanel x="0" y="0" width="100" height="100" title="Default"/>'
		 * 
		 * 
		 * All properties do no necessarily need to be an xml
		 * attribute.  The xml element describing the panel may
		 * contain as many sub-elements as required.
		 * **/
		public function toXml():XML{
			var xmlState:XML = <SaveStatePanel />;
			
			xmlState = saveBasics(xmlState);
			
			return xmlState;
		}
		
		/**
		 * This small helper method saves the basics which should 
		 * apply to all panels:
		 * 
		 * title, x, y, width, height
		 * **/
		protected function saveBasics(state:XML):XML{
			state.@title = title;
			
			if (windowState == WINDOW_STATE_MAXIMIZED ||
				windowState == WINDOW_STATE_MINIMIZED){
					
				state.@x = _oldX;
				state.@y = _oldY;
				state.@width = _oldW;
				state.@height = _oldH;
			} else {
				state.@x = x;
				state.@y = y;
				state.@width = width;
				state.@height = height;
			}
			
			state.@state = windowState;
			
			return state;
		}
		
		//************************************
		// Load
		//************************************
		
		/**
		 * Loads the state of a widget from an xml element produced
		 * by the toXml() method.  
		 * 
		 * This should be able to run both before and after the 
		 * createChildren() method has been executed to prevent
		 * timing issues.
		 * 
		 * **/
		public function fromXml(state:XML):void{
			title = state.@title;
			
			x = state.@x;
			y = state.@y;
			width = state.@width;
			height = state.@height;
			
			windowState = state.@state;
		}
	}
}