package com.edgeti.EdgeUtils
{
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.geom.Matrix;
	import flash.net.URLRequest;
	
	import mx.containers.Canvas;
	import mx.core.UIComponent;

	public class ImageCanvas extends Canvas
	{
		private var _shape:Shape;
		private var _uic:UIComponent;
		private var _bmp:Bitmap;
		private var _matrix:Matrix;
		private var _loader:Loader;
			
		public function ImageCanvas()
		{
			super();
			_matrix = new Matrix();
			_loader = new Loader();

			_loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, faultHandler);
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, handleConfigLoadComplete);
		}
		
		public function set bitmap(bmp:Bitmap):void{
			_bmp = bmp;
			invalidateDisplayList();
		}
		
		override protected function createChildren():void{
			super.createChildren();
			_uic = new UIComponent();
			_uic.percentHeight = 100;
			_uic.percentWidth = 100;
			_shape = new Shape();
			_uic.addChild(_shape);
			addChild(_uic);
			setChildIndex(_uic, 0);
		}
		
		override public function invalidateDisplayList():void{
			super.invalidateDisplayList();
			if(_bmp != null){
				var xScale:Number = width / _bmp.width;
				var yScale:Number = height / _bmp.height;
				_matrix.identity();
				//_matrix.translate(-_imageBitmap.width * 0.5, -_imageBitmap.height * 0.5);
				_matrix.scale(xScale, yScale);
				//_matrix.translate(x, y)
				
				_shape.graphics.beginBitmapFill(_bmp.bitmapData, _matrix, false);
				_shape.graphics.drawRect(0, 0, width, height);
				_shape.graphics.endFill();
			}
		}
		
		public function set imageUrl(url:String):void{			
			_loader.load(new URLRequest(url));
		}
		
		private function faultHandler(evt:IOErrorEvent):void{
			trace(evt.text);
		}
		
		private function handleConfigLoadComplete(evt:Event):void{
			_bmp = evt.currentTarget.content;
			invalidateDisplayList();
		}
	}
}