package com.edgeti.EdgeUtils
{
	import com.edgeti.RemoteClasses.ColumnInfoObject;
	import com.edgeti.RemoteClasses.FlexDateDataObject;
	
	import flash.utils.Dictionary;
	
	import mx.collections.ArrayCollection;
	import mx.collections.Sort;
	
	public class DataUtils
	{
		public function DataUtils()
		{
		}
		
		/**
		 * Coverts data from column based date organization to row based organization (imagine
		 * a table where the columns are dates and rows are categories, this method converts it
		 * to a table with columns as categories and dates as rows for easier display in trending
		 * charts).
		 * 
		 * @param columns date based columns
		 * @param items rows of data broken up by date
		 * 
		 * @return an arraycollection of the same data with rows and columns flipped
		 * **/
		public static function toDateBasedCollection(columns:ArrayCollection, items:Array):ArrayCollection{
			var uniqueDateObjects:Dictionary = new Dictionary();
			var dateObj:FlexDateDataObject;
			
			//Create FlexDateDataObject for each unique date
			for each (var col:ColumnInfoObject in columns){
				if (Utils.isDate(col.name)){
					dateObj = new FlexDateDataObject();
					dateObj.date = new Date(Utils.parseDate(col.name));
					dateObj.dateString = col.name;
					uniqueDateObjects[col.name] = dateObj;
				}
			}
			
			//Fill FlexDateDataObjects
			var obj:Object;
			var str:String;
			var valStr:String;
			var val:Number;
			for each (var item:Object in items){
				if (item.name == null || item.name == ""){
					continue;
				}
				var name:String = item.name;
				for (var datePoint:String in item){
					dateObj = null;
					dateObj = uniqueDateObjects[datePoint];
					if (dateObj){
						valStr = item[datePoint];
						valStr = Utils.replaceAll(valStr, ",", "");
						valStr = Utils.replaceAll(valStr, "$", "");
						val = new Number(valStr);
						if(isNaN(val)){
							dateObj[name] = valStr;
						} else {
							dateObj[name] = val;	
						}
					}
				}
			}
			
			var retCollection:ArrayCollection = new ArrayCollection();
			for (var s:String in uniqueDateObjects){
				retCollection.addItem(uniqueDateObjects[s]);
			}
			
			//Sort it before returning it
			var sort:Sort = new Sort();
			sort.compareFunction = dateCompareFunction;
			retCollection.sort = sort;
			retCollection.refresh();
			
			return retCollection;
		}
		
		public static function dateCompareFunction(a:Object, b:Object, fields:Array = null):int{
			if (a == null && b == null){
				return 0;
			}
			if (a == null){
				return 1;
			}
			if (b == null){
				return -1;
			}
			
			if (a is FlexDateDataObject && b is FlexDateDataObject){
				var aDate:Date = (a as FlexDateDataObject).date;
				var bDate:Date = (b as FlexDateDataObject).date;
				if (aDate.time > bDate.time){
					return 1;
				} else {
					return -1;
				}
			} else {
				return 0;
			}
		}

	}
}