package com.edgeti.EdgeUtils
{
	import com.edgeti.EdgeUtils.logger.Logger;
	
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLLoaderDataFormat;
	import flash.net.URLRequest;
	
	/**
	 * Holds configuration information for access from anywhere in the application.
	 * **/
	dynamic public class ConfigManager
	{
		protected static var logger:Logger = Logger.getLogger();
		
		[Bindable]
		public static var endpoint:String = "https://127.0.0.1/Visibility3/messagebroker/amfsecure";
		[Bindable]
		public static var uploads:String = "https://127.0.0.1/Visibility3/servlet/UploadTest";
		[Bindable]
		public static var downloads:String = "https://127.0.0.1/Visibility3/downloads";
		[Bindable]
		public static var documentation:String = "https://127.0.0.1/Vis2Documentation/index.html";
		[Bindable]
		public static var tutorial:String = "https://127.0.0.1/Vis2Documentation/tutorial.html";
		[Bindable]
		public static var banner:String = "UNCLASSIFIED//FOR OFFICIAL USE ONLY";
		[Bindable]
		public static var infoText:String = "Information String";
		[Bindable]
		public static var debugLogin:String = null;
		[Bindable]
		public static var debugPassword:String = null;
		[Bindable]
		public static var updateTime:Number = 15;
		
		public static var defaultTab:String = "Details";
		
		//UserInfoObject of the user currently logged in
		public static var user:Object;
		
		//DashInfoObject of the current view
		public static var view:Object;
		
		
		//*********************************************
		// Self load and configure
		//*********************************************
		
		/**
		 * Attempts to load the 'properties' file assets/setupModel.xml.
		 * 
		 * @param callback a function to be called once loading of the properties is complete
		 * 
		 */
		public static function configure(callback:Function):void{
			var loader:URLLoader = new URLLoader();
			loader.dataFormat = URLLoaderDataFormat.TEXT;
			loader.addEventListener(IOErrorEvent.IO_ERROR, faultHandler);
			loader.addEventListener(Event.COMPLETE, handleConfigLoadComplete);
			
			_callback = callback;
			
			loader.load(new URLRequest("assets/setupModel.xml"));
		}
		
		protected static var _callback:Function;
		
		/**
		 * Reads the setupModel.xml file once it has been successfully loaded.
		 *  
		 * @param evt Event.COMPLETE
		 * 
		 */
		protected static function handleConfigLoadComplete(evt:Event):void{
			var configXML:XML = new XML(evt.target.data);
			endpoint = configXML.endpoint;
			uploads = configXML.upload;
			downloads = configXML.download;
			debugLogin = configXML.debugLogin;
			debugPassword = configXML.debugPassword;
			updateTime = Number(configXML.updateTime);
			banner = configXML.banner;
			infoText = configXML.infoText;
			if(configXML.defaultTab){
				defaultTab = configXML.defaultTab;
			}
			if (updateTime == 0){
				updateTime = 15;
			}
			if (configXML.documentation){
				documentation = configXML.documentation;
			}
			if (configXML.tutorial){
				tutorial = configXML.tutorial;
			}
			
			logger.info("Connecting to endpoint: " + endpoint);
			
			_callback.call(null);
		}
		
		/**
		 * Called if an error occurs while trying to load setupModel.xml.
		 *  
		 * @param evt IOErrorEvent.IO_ERROR
		 * 
		 */
		protected static function faultHandler(evt:IOErrorEvent):void{
			Logger.getLogger().error(evt.text);
		}
		
		public function ConfigManager()
		{
		}

	}
}